/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.log.html;

import com.ss.android.ugc.bytex.common.log.LevelLog;
import com.ss.android.ugc.bytex.common.log.html.HtmlFragmentProvider;
import com.ss.android.ugc.bytex.common.utils.CalendarUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class HtmlReporter {
    private static final String TAG = "HtmlReporter";
    private static final String CSS = ".DEBUG { color: black; } .INFO { color: black; } .ERROR { color: red; } .WARNING { color: orange; } table { border: 1px solid #e3e6e8; border-collapse: collapse; display: table; } th { background-color: #189AD6; color: #fff; } .side-bar { width: 100px; position: fixed; bottom:100px; right: 100px; z-index: 100; } .side-bar a { width: 66px; height: 66px; display: inline-block; background-color: #ddd; margin-outside: 100px; } .side-bar .icon-chat {background-position: 0 -130px;position: relative;} .side-bar a:hover { background-color: #669fdd; }";
    private static HtmlReporter sInstance;
    private String htmlFileDir = null;
    private String title;
    private long startTime;
    private String appPackageName;
    private String versionName;
    private String versionCode;
    private final List<HtmlFragmentProvider> htmlFragmentProviders = new ArrayList<HtmlFragmentProvider>();

    private HtmlReporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HtmlReporter getInstance() {
        if (sInstance != null) return sInstance;
        Class<HtmlReporter> clazz = HtmlReporter.class;
        synchronized (HtmlReporter.class) {
            if (sInstance != null) return sInstance;
            sInstance = new HtmlReporter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public synchronized void registerHtmlFragment(HtmlFragmentProvider htmlFragmentProvider) {
        if (htmlFragmentProvider == null || this.htmlFragmentProviders.contains(htmlFragmentProvider)) {
            return;
        }
        this.htmlFragmentProviders.add(htmlFragmentProvider);
    }

    public synchronized void init(String htmlFileDir, String title, String appPackageName, String versionName, String versionCode) {
        for (HtmlFragmentProvider htmlFragmentProvider : this.htmlFragmentProviders) {
            htmlFragmentProvider.reset();
        }
        this.htmlFileDir = htmlFileDir;
        this.title = title;
        this.startTime = System.currentTimeMillis();
        this.appPackageName = appPackageName;
        this.versionName = versionName;
        this.versionCode = versionCode;
    }

    public synchronized void reset() {
        this.htmlFragmentProviders.clear();
    }

    public String createHtmlReporter(String transformName) {
        File htmlDir = new File(this.htmlFileDir);
        if (!htmlDir.exists()) {
            htmlDir.mkdirs();
        }
        String fileName = "ByteX_report_" + transformName + ".html";
        File htmlFile = new File(htmlDir, fileName);
        BufferedWriter writer = null;
        try {
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            htmlFile.createNewFile();
            writer = new BufferedWriter(new FileWriter(htmlFile));
            this.appendHtml(writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            return htmlFile.getAbsolutePath();
        }
        catch (IOException e) {
            LevelLog.sDefaultLogger.e(TAG, e.getMessage(), e);
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            return null;
        }
    }

    private synchronized void appendHtml(Appendable appendable) throws IOException {
        appendable.append("<!DOCTYPE html>").append("<html>").append("<head>").append("<meta charset=\"utf-8\">").append("<style type=\"text/css\">").append(CSS).append("</style>").append("<title>").append(this.title).append("</title>").append("</head>").append("<body>").append("<h1>").append(this.title).append("</h1>").append("Transform Start Time: ").append(CalendarUtils.getDateAndTimeString(this.startTime, true)).append("<br>").append("Report Generated Time: ").append(CalendarUtils.getDateAndTimeString(System.currentTimeMillis(), true)).append("<br>").append("App Package Name: ").append(this.appPackageName).append("<br>").append("App Version Name: ").append(this.versionName).append("<br>").append("App Version Code: ").append(this.versionCode).append("<br>").append(String.format("Total modules: %s: ", String.valueOf(this.htmlFragmentProviders.size()))).append("<br>");
        appendable.append("<h2>").append(" Transform or check result: ").append("</h2>").append("<ul>\n");
        for (HtmlFragmentProvider provider : this.htmlFragmentProviders) {
            provider.provideHtmlCode(appendable);
        }
        appendable.append("</ul>");
        appendable.append("<div class=\"side-bar\">\n    <a href=\"#\" class=\"icon-chat\">Back To Top</a>\n</div>");
        appendable.append("</body>").append("</html>");
    }
}

