/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.manifest;

import com.ss.android.ugc.bytex.common.log.LevelLog;
import java.io.File;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class AndroidManifestXmlReader {
    private final SAXReader reader = new SAXReader();
    private String packageName;

    public void read(String filePath, Visitor visitor) {
        File file = new File(filePath);
        this.read(file, visitor);
    }

    public void read(File file, Visitor visitor) {
        try {
            if (visitor.visitFile(file)) {
                return;
            }
            Document document = this.reader.read(file);
            Element root = document.getRootElement();
            this.readNode(root, visitor);
        }
        catch (DocumentException e) {
            LevelLog.sDefaultLogger.e(e.getMessage(), e);
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    private void readNode(Element node, Visitor visitor) {
        block15: {
            List attributes;
            String nodeName;
            block21: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                Object attribute3;
                                block16: {
                                    nodeName = node.getTextTrim().isEmpty() ? node.getName() : node.getTextTrim();
                                    attributes = node.attributes();
                                    if (visitor == null) break block15;
                                    if (!nodeName.equals("manifest")) break block16;
                                    for (Object attribute2 : attributes) {
                                        if (!attribute2.getName().equals("package")) continue;
                                        this.packageName = attribute2.getValue();
                                        visitor.visitPackageName(this.packageName);
                                        break;
                                    }
                                    List elements = node.elements();
                                    for (Element e : elements) {
                                        this.readNode(e, visitor);
                                    }
                                    break block15;
                                }
                                if (!nodeName.equals("application")) break block17;
                                for (Object attribute3 : attributes) {
                                    if (!"name".equals(attribute3.getName()) || !"android".equals(attribute3.getNamespace().getPrefix())) continue;
                                    Object className = attribute3.getValue();
                                    if (className != null && ((String)className).startsWith(".") && this.packageName != null) {
                                        className = this.packageName + (String)className;
                                    }
                                    if (className == null || ((String)className).startsWith(".")) break;
                                    visitor.visitApplication(((String)className).replace(".", "/"), attributes);
                                    break;
                                }
                                List elements = node.elements();
                                attribute3 = elements.iterator();
                                while (attribute3.hasNext()) {
                                    Element e = (Element)attribute3.next();
                                    this.readNode(e, visitor);
                                }
                                break block15;
                            }
                            if (!nodeName.equals("activity-alias")) break block18;
                            for (Attribute attribute : attributes) {
                                if (!"targetActivity".equals(attribute.getName()) || !"android".equals(attribute.getNamespace().getPrefix())) continue;
                                Object className = attribute.getValue();
                                if (className != null && ((String)className).startsWith(".") && this.packageName != null) {
                                    className = this.packageName + (String)className;
                                }
                                List intentFilters = node.elements("intent-filter");
                                if (className == null || ((String)className).startsWith(".")) break block15;
                                visitor.visitActivity(((String)className).replace(".", "/"), attributes, intentFilters);
                                break block15;
                            }
                            break block15;
                        }
                        if (!nodeName.equals("activity")) break block19;
                        for (Attribute attribute : attributes) {
                            if (!"name".equals(attribute.getName()) || !"android".equals(attribute.getNamespace().getPrefix())) continue;
                            Object className = attribute.getValue();
                            if (className != null && ((String)className).startsWith(".") && this.packageName != null) {
                                className = this.packageName + (String)className;
                            }
                            List intentFilters = node.elements("intent-filter");
                            if (className == null || ((String)className).startsWith(".")) break block15;
                            visitor.visitActivity(((String)className).replace(".", "/"), attributes, intentFilters);
                            break block15;
                        }
                        break block15;
                    }
                    if (!nodeName.equals("receiver")) break block20;
                    for (Attribute attribute : attributes) {
                        if (!"name".equals(attribute.getName()) || !"android".equals(attribute.getNamespace().getPrefix())) continue;
                        Object className = attribute.getValue();
                        if (className != null && ((String)className).startsWith(".") && this.packageName != null) {
                            className = this.packageName + (String)className;
                        }
                        if (className == null || ((String)className).startsWith(".")) break block15;
                        visitor.visitReceiver(((String)className).replace(".", "/"));
                        break block15;
                    }
                    break block15;
                }
                if (!nodeName.equals("provider")) break block21;
                for (Attribute attribute : attributes) {
                    if (!"name".equals(attribute.getName()) || !"android".equals(attribute.getNamespace().getPrefix())) continue;
                    Object className = attribute.getValue();
                    if (className != null && ((String)className).startsWith(".") && this.packageName != null) {
                        className = this.packageName + (String)className;
                    }
                    if (className == null || ((String)className).startsWith(".")) break block15;
                    visitor.visitProvider(((String)className).replace(".", "/"));
                    break block15;
                }
                break block15;
            }
            if (!nodeName.equals("service")) break block15;
            for (Attribute attribute : attributes) {
                if (!"name".equals(attribute.getName()) || !"android".equals(attribute.getNamespace().getPrefix())) continue;
                Object className = attribute.getValue();
                if (className != null && ((String)className).startsWith(".") && this.packageName != null) {
                    className = this.packageName + (String)className;
                }
                if (className == null || ((String)className).startsWith(".")) break;
                visitor.visitService(((String)className).replace(".", "/"));
                break;
            }
        }
    }

    public static interface Visitor {
        public void visitApplication(String var1, List<Attribute> var2);

        public void visitActivity(String var1, List<Attribute> var2, List<Element> var3);

        public void visitReceiver(String var1);

        public void visitProvider(String var1);

        public void visitService(String var1);

        default public void visitPackageName(String packageName) {
        }

        default public boolean visitFile(File file) {
            return false;
        }
    }
}

