/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.processor;

import com.android.build.api.transform.Status;
import com.ss.android.ugc.bytex.common.configuration.BooleanProperty;
import com.ss.android.ugc.bytex.common.exception.ByteXException;
import com.ss.android.ugc.bytex.common.exception.GlobalWhiteListManager;
import com.ss.android.ugc.bytex.common.flow.main.MainProcessHandler;
import com.ss.android.ugc.bytex.common.flow.main.Process;
import com.ss.android.ugc.bytex.common.graph.GraphBuilder;
import com.ss.android.ugc.bytex.common.log.LevelLog;
import com.ss.android.ugc.bytex.common.processor.MainProcessFileHandler;
import com.ss.android.ugc.bytex.common.utils.Utils;
import com.ss.android.ugc.bytex.common.visitor.ClassVisitorChain;
import com.ss.android.ugc.bytex.common.visitor.GenerateGraphClassVisitor;
import com.ss.android.ugc.bytex.common.visitor.SafeClassNode;
import com.ss.android.ugc.bytex.transformer.TransformContext;
import com.ss.android.ugc.bytex.transformer.cache.FileData;
import java.util.List;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class ClassFileAnalyzer
extends MainProcessFileHandler {
    private final Process process;
    private final GraphBuilder mGraphBuilder;
    private final TransformContext context;

    @Deprecated
    public ClassFileAnalyzer(TransformContext context2, boolean fromAndroid, @Nullable GraphBuilder graphBuilder, List<MainProcessHandler> handlers) {
        this(context2, fromAndroid ? Process.TRAVERSE_ANDROID : Process.TRAVERSE, graphBuilder, handlers);
    }

    public ClassFileAnalyzer(TransformContext context2, Process process, @Nullable GraphBuilder graphBuilder, List<MainProcessHandler> handlers) {
        super(handlers);
        this.process = process;
        this.mGraphBuilder = graphBuilder;
        this.context = context2;
    }

    @Override
    public void handle(FileData fileData) {
        block12: {
            try {
                List pluginList = this.handlers;
                if (fileData.getStatus() == Status.REMOVED) {
                    if (this.process != Process.TRAVERSE_INCREMENTAL) {
                        throw new IllegalStateException("REMOVED State is only valid in TRAVERSE_INCREMENTAL process");
                    }
                    for (MainProcessHandler handler : pluginList) {
                        handler.traverseIncremental(fileData, (ClassVisitorChain)null);
                        handler.traverseIncremental(fileData, (ClassNode)null);
                    }
                    return;
                }
                byte[] raw = fileData.getBytes();
                String relativePath = fileData.getRelativePath();
                ClassReader cr = new ClassReader(raw);
                int flag = this.getFlag(this.handlers);
                SafeClassNode checkCn = null;
                if (BooleanProperty.CHECK_TRAVERSE_MODIFY.value().booleanValue() && (this.context.isReleaseBuild() || BooleanProperty.CHECK_DEBUG_TRAVERSE_MODIFY.value().booleanValue())) {
                    checkCn = new SafeClassNode();
                    cr.accept((ClassVisitor)checkCn, flag);
                }
                ClassVisitorChain chain = this.getClassVisitorChain(relativePath);
                if (this.mGraphBuilder != null) {
                    chain.connect(new GenerateGraphClassVisitor(this.process == Process.TRAVERSE_ANDROID, this.mGraphBuilder));
                }
                pluginList.forEach(plugin -> {
                    switch (this.process) {
                        case TRAVERSE_INCREMENTAL: {
                            plugin.traverseIncremental(fileData, chain);
                            break;
                        }
                        case TRAVERSE: {
                            plugin.traverse(relativePath, chain);
                            break;
                        }
                        case TRAVERSE_ANDROID: {
                            plugin.traverseAndroidJar(relativePath, chain);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unsupported Process");
                        }
                    }
                });
                SafeClassNode cn = new SafeClassNode();
                chain.append(cn);
                if (checkCn != null) {
                    chain.accept(checkCn);
                    if (ClassFileAnalyzer.checkClassModified(cn, checkCn)) {
                        throw new IllegalStateException("Found plugin modified the class during the traverse process");
                    }
                } else {
                    chain.accept(cr, flag);
                }
                pluginList.forEach(plugin -> {
                    switch (this.process) {
                        case TRAVERSE_INCREMENTAL: {
                            plugin.traverseIncremental(fileData, cn);
                            break;
                        }
                        case TRAVERSE: {
                            plugin.traverse(relativePath, cn);
                            break;
                        }
                        case TRAVERSE_ANDROID: {
                            plugin.traverseAndroidJar(relativePath, cn);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unsupported Process");
                        }
                    }
                });
                if (checkCn != null && ClassFileAnalyzer.checkClassModified(cn, checkCn)) {
                    throw new IllegalStateException("Found plugin modified the class during the traverse process");
                }
            }
            catch (ByteXException e) {
                throw new RuntimeException(String.format("%s\n\tFailed to resolve class %s[%s]", e.getMessage(), fileData.getRelativePath(), Utils.getAllFileCachePath(this.context, fileData.getRelativePath())), e);
            }
            catch (Exception e) {
                e.printStackTrace();
                LevelLog.sDefaultLogger.e(String.format("Failed to read class %s", fileData.getRelativePath()), e);
                if (GlobalWhiteListManager.INSTANCE.shouldIgnore(fileData.getRelativePath())) break block12;
                throw new RuntimeException(String.format("%s\n\tFailed to resolve class %s[%s]", e.getMessage(), fileData.getRelativePath(), Utils.getAllFileCachePath(this.context, fileData.getRelativePath())), e);
            }
        }
    }

    private int getFlag(List<MainProcessHandler> handlers) {
        int flag = 0;
        boolean needSkipCode = true;
        boolean needSkipDebug = true;
        boolean needSkipFrame = true;
        for (MainProcessHandler handler : handlers) {
            int flagForClassReader = handler.flagForClassReader(this.process);
            flag |= flagForClassReader;
            needSkipCode = needSkipCode && (flagForClassReader & 1) != 0;
            needSkipDebug = needSkipDebug && (flagForClassReader & 2) != 0;
            needSkipFrame = needSkipFrame && (flagForClassReader & 4) != 0;
        }
        if (!needSkipCode) {
            flag &= 0xFFFFFFFE;
        }
        if (!needSkipDebug) {
            flag &= 0xFFFFFFFD;
        }
        if (!needSkipFrame) {
            flag &= 0xFFFFFFFB;
        }
        if ((flag & 8) != 0) {
            flag &= 0xFFFFFFFE;
            flag &= 0xFFFFFFFB;
        }
        return flag;
    }

    private static boolean checkClassModified(ClassNode n1, ClassNode n2) {
        ClassWriter cw1 = new ClassWriter(1);
        n1.accept((ClassVisitor)cw1);
        byte[] b1 = cw1.toByteArray();
        ClassWriter cw2 = new ClassWriter(1);
        n2.accept((ClassVisitor)cw2);
        byte[] b2 = cw2.toByteArray();
        if (b1.length != b2.length) {
            return true;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return true;
        }
        return false;
    }
}

