/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.utils;

import com.ss.android.ugc.bytex.common.utils.ExtensionsKt;
import com.ss.android.ugc.bytex.common.utils.FileHandler;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0002\u0011\u0012B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/ss/android/ugc/bytex/common/utils/FileHandler;", "Lorg/gradle/api/Action;", "Ljava/util/function/Consumer;", "Lcom/ss/android/ugc/bytex/common/utils/FileHandler$FileData;", "files", "", "Ljava/io/File;", "deepTraverse", "", "(Ljava/util/Collection;Z)V", "consumer", "getDeepTraverse", "()Z", "getFiles", "()Ljava/util/Collection;", "execute", "", "FileData", "PathResolver", "TransformEngine"})
public final class FileHandler
implements Action<Consumer<FileData>> {
    private Consumer<FileData> consumer;
    @NotNull
    private final Collection<File> files;
    private final boolean deepTraverse;

    public void execute(@NotNull Consumer<FileData> consumer) {
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        this.consumer = consumer;
        boolean bl = false;
        List inputs = new ArrayList();
        Iterable $this$forEach$iv = this.files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File rootFile = (File)element$iv;
            boolean bl2 = false;
            if (rootFile.isFile()) {
                inputs.add(new PathResolver(rootFile, "", this.deepTraverse));
                continue;
            }
            if (!rootFile.isDirectory()) continue;
            ExtensionsKt.traverseFile(rootFile, (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(rootFile, this, inputs){
                final /* synthetic */ File $rootFile;
                final /* synthetic */ FileHandler this$0;
                final /* synthetic */ List $inputs$inlined;
                {
                    this.$rootFile = file;
                    this.this$0 = fileHandler;
                    this.$inputs$inlined = list;
                    super(1);
                }

                public final void invoke(@NotNull File singleFile) {
                    Intrinsics.checkParameterIsNotNull((Object)singleFile, (String)"singleFile");
                    this.$inputs$inlined.add(this.this$0.new PathResolver(singleFile, FilesKt.toRelativeString((File)singleFile, (File)this.$rootFile), this.this$0.getDeepTraverse()));
                }
            }));
        }
        inputs.parallelStream().forEach(execute.2.INSTANCE);
        this.consumer = null;
    }

    @NotNull
    public final Collection<File> getFiles() {
        return this.files;
    }

    public final boolean getDeepTraverse() {
        return this.deepTraverse;
    }

    public FileHandler(@NotNull Collection<? extends File> files, boolean deepTraverse) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        this.files = files;
        this.deepTraverse = deepTraverse;
    }

    public /* synthetic */ FileHandler(Collection collection, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(collection, bl);
    }

    public static final /* synthetic */ void access$setConsumer$p(FileHandler $this, Consumer consumer) {
        $this.consumer = consumer;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0002H\u0016J&\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/ss/android/ugc/bytex/common/utils/FileHandler$PathResolver;", "Ljava/util/concurrent/Callable;", "", "file", "Ljava/io/File;", "toRelativeString", "", "deepTraverse", "", "(Lcom/ss/android/ugc/bytex/common/utils/FileHandler;Ljava/io/File;Ljava/lang/String;Z)V", "getDeepTraverse", "()Z", "getFile", "()Ljava/io/File;", "getToRelativeString", "()Ljava/lang/String;", "call", "path", "bytes", "", "simpleEntryConsumer", "Ljava/util/function/Consumer;", "Lcom/ss/android/ugc/bytex/common/utils/FileHandler$FileData;", "TransformEngine"})
    private final class PathResolver
    implements Callable<Unit> {
        @NotNull
        private final File file;
        @NotNull
        private final String toRelativeString;
        private final boolean deepTraverse;

        @Override
        public void call() {
            String string = this.file.getName();
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            String string2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
            if (StringsKt.endsWith$default((String)string2, (String)"jar", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)"zip", (boolean)false, (int)2, null)) {
                try {
                    LinkedList dataList = new LinkedList();
                    ExtensionsKt.unzip(this.file, (Function2<? super String, ? super byte[], Unit>)((Function2)new Function2<String, byte[], Unit>(this, dataList){
                        final /* synthetic */ PathResolver this$0;
                        final /* synthetic */ LinkedList $dataList;

                        public final void invoke(@NotNull String name, @NotNull byte[] data) {
                            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                            String path = this.this$0.getToRelativeString() + '!' + name;
                            if (this.this$0.getDeepTraverse()) {
                                PathResolver.access$deepTraverse(this.this$0, path, data, new Consumer<FileData>(this){
                                    final /* synthetic */ call.2 this$0;

                                    public final void accept(@NotNull FileData it) {
                                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                        this.this$0.$dataList.add(it);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                    }
                                });
                            } else {
                                this.$dataList.add(new FileData(this.this$0.getFile(), path, data));
                            }
                        }
                        {
                            this.this$0 = pathResolver;
                            this.$dataList = linkedList;
                            super(2);
                        }
                    }));
                    dataList.parallelStream().forEach((Consumer)new Consumer<FileData>(this){
                        final /* synthetic */ PathResolver this$0;

                        public final void accept(FileData it) {
                            Consumer consumer = FileHandler.access$getConsumer$p(this.this$0.FileHandler.this);
                            if (consumer == null) {
                                Intrinsics.throwNpe();
                            }
                            consumer.accept(it);
                        }
                        {
                            this.this$0 = pathResolver;
                        }
                    });
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Consumer consumer = FileHandler.this.consumer;
            if (consumer == null) {
                Intrinsics.throwNpe();
            }
            consumer.accept(new FileData(this.file, this.toRelativeString, FilesKt.readBytes((File)this.file)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void deepTraverse(String path, byte[] bytes, Consumer<FileData> simpleEntryConsumer) {
            Closeable closeable = new ZipInputStream(new ByteArrayInputStream(bytes));
            boolean bl = false;
            Throwable throwable = null;
            try {
                ZipInputStream zin = (ZipInputStream)closeable;
                boolean bl2 = false;
                boolean isZipFile = false;
                Ref.ObjectRef zipEntry = new Ref.ObjectRef();
                while (true) {
                    ZipEntry zipEntry2 = zin.getNextEntry();
                    boolean bl3 = false;
                    boolean bl4 = false;
                    ZipEntry it = zipEntry2;
                    boolean bl5 = false;
                    zipEntry.element = it;
                    if (zipEntry2 == null) break;
                    isZipFile = true;
                    ZipEntry zipEntry3 = (ZipEntry)zipEntry.element;
                    if (zipEntry3 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (zipEntry3.isDirectory()) continue;
                    StringBuilder stringBuilder = new StringBuilder().append(path).append("!");
                    ZipEntry zipEntry4 = (ZipEntry)zipEntry.element;
                    if (zipEntry4 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.deepTraverse(stringBuilder.append(zipEntry4.getName()).toString(), ByteStreamsKt.readBytes((InputStream)zin), simpleEntryConsumer);
                }
                if (!isZipFile) {
                    simpleEntryConsumer.accept(new FileData(this.file, path, bytes));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @NotNull
        public final String getToRelativeString() {
            return this.toRelativeString;
        }

        public final boolean getDeepTraverse() {
            return this.deepTraverse;
        }

        public PathResolver(@NotNull File file, String toRelativeString, boolean deepTraverse) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)toRelativeString, (String)"toRelativeString");
            this.file = file;
            this.toRelativeString = toRelativeString;
            this.deepTraverse = deepTraverse;
        }

        public static final /* synthetic */ void access$deepTraverse(PathResolver $this, String path, byte[] bytes, Consumer simpleEntryConsumer) {
            $this.deepTraverse(path, bytes, simpleEntryConsumer);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\n\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/ss/android/ugc/bytex/common/utils/FileHandler$FileData;", "", "file", "Ljava/io/File;", "path", "", "bytes", "", "(Ljava/io/File;Ljava/lang/String;[B)V", "getBytes", "()[B", "getFile", "()Ljava/io/File;", "name", "getName", "()Ljava/lang/String;", "getPath", "TransformEngine"})
    public static final class FileData {
        @NotNull
        private final String name;
        @NotNull
        private final File file;
        @NotNull
        private final String path;
        @NotNull
        private final byte[] bytes;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final byte[] getBytes() {
            return this.bytes;
        }

        public FileData(@NotNull File file, @NotNull String path, @NotNull byte[] bytes) {
            String string;
            String string2;
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
            this.file = file;
            this.path = path;
            this.bytes = bytes;
            int n = StringsKt.lastIndexOf$default((CharSequence)this.path, (String)"!", (int)0, (boolean)false, (int)6, null);
            FileData fileData = this;
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            if (it >= 0) {
                String string3 = this.path;
                int n2 = it + 1;
                boolean bl4 = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n2);
                string2 = string5;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string2 = this.path;
            }
            fileData.name = string = string2;
        }
    }
}

