/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TypeUtil {
    private static Pattern paramsPat = Pattern.compile("(\\[?[BCZSIJFD])|(L[^;]+;)");
    private static Map<Integer, String> sAccessMapForMethod;

    public static Map<Integer, String> getCheckedAccessMapForMethod() {
        if (sAccessMapForMethod == null) {
            sAccessMapForMethod = TypeUtil.getAccessMapForMethod();
        }
        return sAccessMapForMethod;
    }

    public static Map<Integer, String> getAccessMapForMethod() {
        HashMap<Integer, String> map = new HashMap<Integer, String>(12);
        map.put(1, "PUBLIC");
        map.put(2, "PRIVATE");
        map.put(4, "PROTECTED");
        map.put(8, "STATIC");
        map.put(16, "FINAL");
        map.put(32, "SYNCHRONIZED");
        map.put(64, "BRIDGE");
        map.put(128, "VARARGS");
        map.put(256, "NATIVE");
        map.put(1024, "ABSTRACT");
        map.put(2048, "STRICT");
        map.put(4096, "SYNTHETIC");
        return map;
    }

    public static String removeFirstParam(String desc) {
        if (desc.startsWith("()")) {
            return desc;
        }
        int index = 1;
        char c = desc.charAt(index);
        while (c == '[') {
            c = desc.charAt(++index);
        }
        if (c == 'L') {
            while (desc.charAt(index) != ';') {
                ++index;
            }
        }
        return "(" + desc.substring(index + 1);
    }

    public static int getParameterCountFromMethodDesc(String desc) {
        int endIndex;
        int beginIndex = desc.indexOf(40) + 1;
        String paramsDesc = desc.substring(beginIndex, endIndex = desc.lastIndexOf(41));
        if (paramsDesc.isEmpty()) {
            return 0;
        }
        int count = 0;
        Matcher matcher = paramsPat.matcher(paramsDesc);
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public static List<String> splitMethodParametersFromDesc(String desc) {
        int endIndex;
        int beginIndex = desc.indexOf(40) + 1;
        String paramsDesc = desc.substring(beginIndex, endIndex = desc.lastIndexOf(41));
        if (paramsDesc.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> types = new ArrayList<String>();
        Matcher matcher = paramsPat.matcher(paramsDesc);
        while (matcher.find()) {
            types.add(matcher.group());
        }
        return types;
    }

    public static String getMethodReturnValue(String desc) {
        int startIndex = desc.lastIndexOf(41);
        return desc.substring(startIndex + 1);
    }

    public static String desc2Name(String desc) {
        if (!desc.startsWith("L") && !desc.endsWith(";")) {
            return desc;
        }
        return desc.substring(1, desc.length() - 1);
    }

    public static String className2Desc(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        return String.format("L%s;", name);
    }

    public static String descToStatic(int access, String desc, String className) {
        if ((access & 8) == 0) {
            desc = "(L" + className.replace('.', '/') + ";" + ((String)desc).substring(1);
        }
        return desc;
    }

    public static String descToNonStatic(String desc) {
        return "(" + desc.substring(desc.indexOf(59) + 1);
    }

    public static int parseArray(int index, String desc) {
        while (desc.charAt(index) == '[') {
            ++index;
        }
        if (desc.charAt(index) == 'L') {
            while (desc.charAt(index) != ';') {
                ++index;
            }
        }
        return index;
    }

    public static int parseObject(int index, String desc) {
        while (desc.charAt(index) != ';') {
            ++index;
        }
        return index;
    }

    public static boolean isStatic(int access) {
        return (access & 8) == 8;
    }

    public static boolean isAbstract(int access) {
        return (access & 0x400) == 1024;
    }

    public static boolean isNative(int access) {
        return (access & 0x100) == 256;
    }

    public static boolean isSynthetic(int access) {
        return (access & 0x1000) == 4096;
    }

    public static boolean isBridge(int access) {
        return (access & 0x40) == 64;
    }

    public static boolean isSynchronized(int access) {
        return (access & 0x20) == 32;
    }

    public static boolean isPrivate(int access) {
        return (access & 2) == 2;
    }

    public static boolean isPublic(int access) {
        return (access & 1) == 1;
    }

    public static boolean isProtected(int access) {
        return (access & 4) == 4;
    }

    public static boolean isPackage(int access) {
        return !TypeUtil.isPrivate(access) && !TypeUtil.isProtected(access) && !TypeUtil.isPublic(access);
    }

    public static boolean isTransient(int access) {
        return (access & 0x80) == 128;
    }

    public static int resetAccessScope(int access, int scope) {
        return access & 0xFFFFFFF8 | scope;
    }

    public static boolean isInterface(int access) {
        return (access & 0x200) == 512;
    }

    public static boolean isInt(String desc) {
        return "I".equals(desc);
    }

    public static boolean isIntArray(String desc) {
        return "[I".equals(desc);
    }

    public static boolean isFinal(int access) {
        return (access & 0x10) == 16;
    }

    public static boolean isPrimitive(String desc) {
        return desc != null && desc.length() == 1 && "BCZSIJFD".contains(desc);
    }

    public static String getCanonicalName(String name) {
        return name.replace("/", ".");
    }

    public static String access2StringForMethod(int access) {
        return TypeUtil.getCheckedAccessMapForMethod().get(access);
    }
}

