/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.visitor;

import com.ss.android.ugc.bytex.common.visitor.BaseClassVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class ClassVisitorChain {
    private BaseClassVisitor head;
    private BaseClassVisitor tail;
    private ClassWriter classWriter;

    public ClassVisitorChain() {
    }

    public ClassVisitorChain(ClassWriter cw) {
        this.classWriter = cw;
    }

    public ClassVisitorChain connect(BaseClassVisitor cv) {
        if (cv == null) {
            return this;
        }
        if (this.tail != null) {
            this.tail.setNext(cv);
            this.tail = cv;
        } else {
            this.head = this.tail = cv;
            this.tail.setNext((ClassVisitor)this.classWriter);
        }
        return this;
    }

    public ClassVisitorChain append(ClassNode cv) {
        if (this.tail != null) {
            this.tail.setNext((ClassVisitor)cv);
        } else {
            this.head = this.tail = new BaseClassVisitor((ClassVisitor)cv);
        }
        return this;
    }

    public ClassVisitorChain classWriter(ClassWriter classWriter) {
        this.classWriter = classWriter;
        if (this.tail != null) {
            this.tail.setNext((ClassVisitor)classWriter);
        }
        return this;
    }

    public byte[] accept(ClassReader classReader) {
        return this.accept(classReader, 0);
    }

    public byte[] accept(ClassReader classReader, int flag) {
        if (this.head != null) {
            classReader.accept((ClassVisitor)this.head, flag);
        }
        if (this.classWriter != null) {
            return this.classWriter.toByteArray();
        }
        return null;
    }

    public byte[] accept(ClassNode classNode) {
        if (this.head != null) {
            classNode.accept((ClassVisitor)this.head);
        }
        if (this.classWriter != null) {
            return this.classWriter.toByteArray();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.head == null;
    }
}

