/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.white_list;

import com.android.utils.Pair;
import com.ss.android.ugc.bytex.common.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class WhiteList {
    private final Map<String, List<Pair<Pattern, Pattern>>> excludeList = new HashMap<String, List<Pair<Pattern, Pattern>>>();

    public void initWithWhiteList(List<String> whiteList) {
        if (!this.excludeList.isEmpty()) {
            this.excludeList.clear();
        }
        if (whiteList != null) {
            whiteList.forEach(s -> {
                String[] split = s.split("#");
                String key = s.substring(0, 1);
                if (key.equals("*") || key.equals(".") || key.equals("?") || key.equals("+")) {
                    key = "";
                }
                if (split.length == 1) {
                    this.addWhiteListEntry(key, (Pair<Pattern, Pattern>)Pair.of((Object)Pattern.compile(Utils.convertToPatternString(Utils.resolveDollarChar(s))), (Object)Utils.PATTERN_MATCH_ALL));
                } else if (split.length == 2) {
                    this.addWhiteListEntry(key, (Pair<Pattern, Pattern>)Pair.of((Object)Pattern.compile(Utils.convertToPatternString(Utils.resolveDollarChar(split[0]))), (Object)Pattern.compile(Utils.convertToPatternString(Utils.resolveDollarChar(split[1])))));
                }
            });
        }
    }

    public void addWhiteListEntry(String prefix, Pair<Pattern, Pattern> entry) {
        this.excludeList.computeIfAbsent(prefix, k -> new ArrayList()).add(entry);
    }

    public boolean shouldCheck(String className) {
        return this.shouldCheck(className, ".*");
    }

    public boolean shouldCheck(String className, String member) {
        boolean matched = false;
        if (className.isEmpty()) {
            return true;
        }
        List<Pair<Pattern, Pattern>> whiteList = this.getWhiteList(className);
        if (whiteList == null || whiteList.isEmpty()) {
            return true;
        }
        for (Pair<Pattern, Pattern> pair : whiteList) {
            Pattern classPat = (Pattern)pair.getFirst();
            Pattern methodPat = (Pattern)pair.getSecond();
            if (!classPat.matcher(className).matches() || !methodPat.matcher(member).matches()) continue;
            matched = true;
            break;
        }
        return !matched;
    }

    private List<Pair<Pattern, Pattern>> getWhiteList(String className) {
        List<Pair<Pattern, Pattern>> allMatch = this.excludeList.getOrDefault("", Collections.emptyList());
        List<Pair<Pattern, Pattern>> filterMath = this.excludeList.getOrDefault(className.substring(0, 1), Collections.emptyList());
        if (allMatch.isEmpty()) {
            return filterMath;
        }
        if (filterMath.isEmpty()) {
            return allMatch;
        }
        ArrayList<Pair<Pattern, Pattern>> result = new ArrayList<Pair<Pattern, Pattern>>(allMatch.size() + filterMath.size());
        result.addAll(filterMath);
        result.addAll(allMatch);
        return result;
    }

    public boolean isEmpty() {
        return this.excludeList.isEmpty();
    }

    public void clear() {
        this.excludeList.clear();
    }
}

