/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.transformer.cache;

import com.android.build.api.transform.Status;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class FileData
implements Serializable {
    private byte[] bytes;
    private LoadFunction bytesCallable;
    private String relativePath;
    private List<FileData> attachment = Collections.emptyList();
    private Status status;

    public FileData(byte[] bytes, String relativePath) {
        this(bytes, relativePath, Status.ADDED);
    }

    public FileData(byte[] bytes, String relativePath, Status status) {
        this.bytes = bytes;
        this.relativePath = relativePath;
        this.status = status;
    }

    public FileData(LoadFunction bytesCallable, String relativePath, Status status) {
        this.bytesCallable = bytesCallable;
        this.bytes = null;
        this.relativePath = relativePath;
        this.status = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        if (this.bytesCallable != null) {
            FileData fileData = this;
            synchronized (fileData) {
                if (this.bytesCallable != null) {
                    try {
                        this.setBytes(this.bytesCallable.load(this), this.status);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.bytes;
    }

    public void delete() {
        this.setBytes(null);
    }

    public void setBytes(byte[] bytes) {
        this.setBytes(bytes, this.getBytes() == bytes ? this.status : (bytes == null ? Status.REMOVED : Status.CHANGED));
    }

    public void setBytes(byte[] bytes, Status status) {
        this.bytes = bytes;
        this.status = status;
        this.bytesCallable = null;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    @Deprecated
    public List<FileData> getAttachment() {
        return Collections.unmodifiableList(this.attachment);
    }

    public void traverseAttachmentOnly(Consumer<FileData> consumer) {
        for (FileData fileData : Collections.unmodifiableList(this.attachment)) {
            consumer.accept(fileData);
        }
    }

    public void traverseAll(Consumer<FileData> consumer) {
        consumer.accept(this);
        this.traverseAttachmentOnly(fileData -> fileData.traverseAll(consumer));
    }

    public List<FileData> allFiles() {
        ArrayList<FileData> result = new ArrayList<FileData>();
        this.traverseAll(result::add);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(FileData fileData) {
        FileData fileData2 = this;
        synchronized (fileData2) {
            if (this.attachment.isEmpty()) {
                this.attachment = new ArrayList<FileData>();
            }
            this.attachment.add(fileData);
        }
    }

    public boolean isDeleted() {
        return this.getBytes() == null;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean contentLoaded() {
        return this.bytesCallable == null;
    }

    public static interface LoadFunction {
        public byte[] load(FileData var1) throws IOException;
    }
}

