/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.transformer.io;

import com.android.build.gradle.AppExtension;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.internal.hash.Hashing;
import org.gradle.wrapper.Download;
import org.gradle.wrapper.ExclusiveFileAccessManager;
import org.gradle.wrapper.Logger;

public interface AndroidJarProvider {
    public static final AndroidJarProvider DEFAULT = new AndroidJarProvider(){

        @Override
        public File getAndroidJar(@Nonnull Project project, @Nonnull AppExtension android) {
            return new File(String.join((CharSequence)File.separator, android.getSdkDirectory().getAbsolutePath(), "platforms", android.getCompileSdkVersion(), "android.jar"));
        }
    };

    @Nullable
    public File getAndroidJar(@Nonnull Project var1, @Nonnull AppExtension var2);

    public static final class URIAndroidJarProvider
    implements AndroidJarProvider {
        private static final Map<URI, URIAndroidJarProvider> cachingAndroidJarProviders = new ConcurrentHashMap<URI, URIAndroidJarProvider>();
        private final URI uri;
        private final String name;

        public static AndroidJarProvider obtain(URI uri) {
            return cachingAndroidJarProviders.computeIfAbsent(uri, new Function<URI, URIAndroidJarProvider>(){

                @Override
                public URIAndroidJarProvider apply(URI uri) {
                    return new URIAndroidJarProvider(uri);
                }
            });
        }

        private URIAndroidJarProvider(URI uri) {
            this.uri = uri;
            String path = uri.getPath();
            String lastPathName = path.substring(path.lastIndexOf("/"));
            this.name = lastPathName.endsWith(".jar") ? lastPathName : lastPathName + ".jar";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public synchronized File getAndroidJar(@Nonnull Project project, @Nonnull AppExtension android) {
            try {
                int tryTimes = 0;
                while (tryTimes++ < 3) {
                    File result;
                    block8: {
                        result = this.getAndroidJarDirect(project, android);
                        if (!this.checkArtifact(result)) break block8;
                        File file = result;
                        return file;
                    }
                    try {
                        result.delete();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                File file = null;
                return file;
            }
            finally {
                cachingAndroidJarProviders.remove(this.uri);
            }
        }

        private File getAndroidJarDirect(final @Nonnull Project project, @Nonnull AppExtension android) throws Exception {
            final File androidJarCacheFile = new File(project.getGradle().getGradleUserHomeDir(), "caches/androidJar/" + this.name + "-" + Hashing.hashString((CharSequence)this.uri.toString()) + "/" + this.name);
            if (androidJarCacheFile.exists()) {
                return androidJarCacheFile;
            }
            return (File)new ExclusiveFileAccessManager(120000, 200).access(androidJarCacheFile, (Callable)new Callable<File>(){

                @Override
                public File call() throws Exception {
                    if (androidJarCacheFile.exists()) {
                        return androidJarCacheFile;
                    }
                    File tempFile = new File(androidJarCacheFile.getParentFile(), androidJarCacheFile.getName() + ".part");
                    tempFile.delete();
                    new Download(new Logger(false), "androidJar", project.getGradle().getGradleVersion()).download(URIAndroidJarProvider.safeUri(uri), tempFile);
                    tempFile.renameTo(androidJarCacheFile);
                    return androidJarCacheFile;
                }
            });
        }

        private boolean checkArtifact(File file) {
            if (!file.exists()) {
                return false;
            }
            try {
                try (ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));){
                    ZipEntry zipEntry;
                    while ((zipEntry = zin.getNextEntry()) != null) {
                        if (zipEntry.isDirectory()) continue;
                        ByteStreams.toByteArray((InputStream)zin);
                    }
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        static URI safeUri(URI uri) throws URISyntaxException {
            return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
    }
}

