/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.transformer.processor.task;

import com.ss.android.ugc.bytex.transformer.TransformContext;
import com.ss.android.ugc.bytex.transformer.cache.FileCache;
import com.ss.android.ugc.bytex.transformer.cache.FileData;
import com.ss.android.ugc.bytex.transformer.processor.FileProcessor;
import com.ss.android.ugc.bytex.transformer.processor.task.FileCacheWriter;
import com.ss.android.ugc.bytex.transformer.processor.task.TraverseTask;
import io.reactivex.functions.Consumer;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;

public class FileTransformTask
extends RecursiveAction
implements Callable<Void> {
    private final List<FileProcessor> processors;
    private final FileCache fileCache;
    private final TransformContext context;

    public FileTransformTask(TransformContext context2, FileCache f, List<FileProcessor> processors) {
        this.context = context2;
        this.processors = processors;
        this.fileCache = f;
    }

    @Override
    public Void call() throws Exception {
        this.fileCache.forEach((Consumer<FileData>)((Consumer)file -> new TraverseTask(this.fileCache, (FileData)file, this.processors)));
        this.fileCache.transformOutput();
        return null;
    }

    @Override
    protected void compute() {
        try {
            List tasks = (List)this.fileCache.stream().map(file -> new TraverseTask(this.fileCache, (FileData)file, this.processors)).toList().blockingGet();
            FileTransformTask.invokeAll(tasks);
            ForkJoinPool.managedBlock(new FileCacheWriter(this.fileCache));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

