/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.variant.VariantInfo;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.builder.model.ProductFlavor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.ss.android.ugc.bytex.common.BaseContext;
import com.ss.android.ugc.bytex.common.BaseExtension;
import com.ss.android.ugc.bytex.common.IPlugin;
import com.ss.android.ugc.bytex.common.TransformConfiguration;
import com.ss.android.ugc.bytex.common.builder.internal.GlobalByteXBuildListener;
import com.ss.android.ugc.bytex.common.configuration.BooleanProperty;
import com.ss.android.ugc.bytex.common.internal.TransformFlowerManager;
import com.ss.android.ugc.bytex.common.log.LevelLog;
import com.ss.android.ugc.bytex.common.log.Timer;
import com.ss.android.ugc.bytex.common.log.html.HtmlReporter;
import com.ss.android.ugc.bytex.common.utils.HeapDumper;
import com.ss.android.ugc.bytex.gradletoolkit.ProjectKt;
import com.ss.android.ugc.bytex.transformer.TransformContext;
import com.ss.android.ugc.bytex.transformer.TransformOptions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public abstract class CommonTransform<X extends BaseContext>
extends Transform {
    protected final X context;
    private Set<TransformConfiguration> configurations;
    @Nullable
    private String applyingVariantName = null;

    public CommonTransform(X context2) {
        this.context = context2;
    }

    public String getName() {
        return ((BaseExtension)((BaseContext)this.context).extension).getName();
    }

    public final boolean applyToVariant(VariantInfo variant) {
        this.applyingVariantName = variant.getFullVariantName();
        return super.applyToVariant(variant);
    }

    @Nullable
    private VariantScope getApplyingVariantScope() {
        return this.applyingVariantName == null ? null : ProjectKt.findVariantScope(((BaseContext)this.context).project, this.applyingVariantName);
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        ImmutableSet result = ImmutableSet.of();
        for (TransformConfiguration config : this.getConfigurations()) {
            Set<QualifiedContent.ContentType> inputTypes = config.getInputTypes();
            if (result.containsAll(inputTypes)) continue;
            result = Sets.union((Set)result, inputTypes);
        }
        if (result.isEmpty()) {
            return TransformConfiguration.DEFAULT.getInputTypes();
        }
        return result;
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        ImmutableSet result = ImmutableSet.of();
        VariantScope variantScope = this.getApplyingVariantScope();
        for (TransformConfiguration config : this.getConfigurations()) {
            Set<? super QualifiedContent.Scope> scopes = config.getScopes(variantScope);
            if (result.containsAll(scopes)) continue;
            result = Sets.union((Set)result, scopes);
        }
        if (result.isEmpty()) {
            return TransformConfiguration.DEFAULT.getScopes(variantScope);
        }
        return result;
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        Set result = super.getOutputTypes();
        for (TransformConfiguration config : this.getConfigurations()) {
            Set<QualifiedContent.ContentType> outputTypes = config.getOutputTypes();
            if (result.containsAll(outputTypes)) continue;
            result = Sets.union((Set)result, outputTypes);
        }
        if (result.isEmpty()) {
            return TransformConfiguration.DEFAULT.getOutputTypes();
        }
        return result;
    }

    public Set<? super QualifiedContent.Scope> getReferencedScopes() {
        Set result = super.getReferencedScopes();
        VariantScope variantScope = this.getApplyingVariantScope();
        for (TransformConfiguration config : this.getConfigurations()) {
            Set<? super QualifiedContent.Scope> referencedScopes = config.getReferencedScopes(variantScope);
            if (result.containsAll(referencedScopes)) continue;
            result = Sets.union((Set)result, referencedScopes);
        }
        if (result.isEmpty()) {
            return TransformConfiguration.DEFAULT.getReferencedScopes(variantScope);
        }
        return result;
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        ArrayList<SecondaryFile> result = new ArrayList<SecondaryFile>(super.getSecondaryFiles());
        for (TransformConfiguration config : this.getConfigurations()) {
            Collection<SecondaryFile> secondaryFiles = config.getSecondaryFiles();
            for (SecondaryFile file : secondaryFiles) {
                if (file == null || result.contains(file)) continue;
                result.add(file);
            }
        }
        return ImmutableList.copyOf(result);
    }

    public Collection<File> getSecondaryFileOutputs() {
        ArrayList<File> result = new ArrayList<File>(super.getSecondaryFileOutputs());
        for (TransformConfiguration config : this.getConfigurations()) {
            Collection<File> secondaryFiles = config.getSecondaryFileOutputs();
            for (File file : secondaryFiles) {
                if (file == null || result.contains(file)) continue;
                result.add(file);
            }
        }
        return ImmutableList.copyOf(result);
    }

    public Collection<File> getSecondaryDirectoryOutputs() {
        ArrayList<File> result = new ArrayList<File>(super.getSecondaryDirectoryOutputs());
        for (TransformConfiguration config : this.getConfigurations()) {
            Collection<File> outputs = config.getSecondaryDirectoryOutputs();
            for (File file : outputs) {
                if (file == null || result.contains(file)) continue;
                result.add(file);
            }
        }
        return ImmutableList.copyOf(result);
    }

    public Map<String, Object> getParameterInputs() {
        HashMap<String, Object> result = new HashMap<String, Object>(super.getParameterInputs());
        for (TransformConfiguration config : this.getConfigurations()) {
            Map<String, Object> parameterInputs = config.getParameterInputs();
            result.putAll(parameterInputs);
        }
        return ImmutableMap.copyOf(result);
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean shouldSaveCache() {
        return ((BaseExtension)((BaseContext)this.context).extension).isShouldSaveCache() && this.getPlugins().stream().allMatch(IPlugin::shouldSaveCache);
    }

    public final synchronized void transform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        try {
            GlobalByteXBuildListener.INSTANCE.onByteXPluginTransformStart(this, transformInvocation);
            this.transformInternal(transformInvocation);
            GlobalByteXBuildListener.INSTANCE.onByteXPluginTransformFinished(this, null);
        }
        catch (Exception e) {
            GlobalByteXBuildListener.INSTANCE.onByteXPluginTransformFinished(this, e);
            throw e;
        }
    }

    private void transformInternal(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        super.transform(transformInvocation);
        if (!transformInvocation.isIncremental() && transformInvocation.getOutputProvider() != null) {
            transformInvocation.getOutputProvider().deleteAll();
        }
        TransformContext transformContext = this.getTransformContext(transformInvocation);
        this.init(transformContext);
        List<IPlugin> plugins2 = this.getPlugins().stream().filter(p -> p.enable(transformContext)).collect(Collectors.toList());
        if (plugins2.stream().anyMatch(iPlugin -> !iPlugin.transformConfiguration().isIncremental())) {
            transformContext.requestNotIncremental();
        }
        Timer timer = new Timer();
        TransformFlowerManager manager = new TransformFlowerManager(transformContext);
        try {
            if (!plugins2.isEmpty()) {
                plugins2.forEach(iPlugin -> iPlugin.startExecute(transformContext));
                plugins2.forEach(plugin -> manager.bind(manager1 -> plugin.registerTransformFlow(manager1.getCommonFlow(), transformContext)));
                manager.onPreTransform();
                manager.runTransform();
                manager.onPostTransform();
            } else {
                manager.skipTransform();
            }
            this.afterTransform(transformInvocation);
        }
        catch (Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                HeapDumper.dumpHeap(((BaseContext)this.context).project.getBuildDir().getAbsolutePath() + "/oom.hprof", true);
            }
            LevelLog.sDefaultLogger.e(throwable.getClass().getName(), throwable);
            throw throwable;
        }
        finally {
            for (IPlugin plugin2 : plugins2) {
                try {
                    plugin2.afterExecute();
                }
                catch (Throwable throwable) {
                    LevelLog.sDefaultLogger.e("do afterExecute", throwable);
                }
            }
            transformContext.release();
            this.configurations = null;
            timer.record("Total cost time = [%s ms]");
            if (BooleanProperty.ENABLE_HTML_LOG.value().booleanValue()) {
                HtmlReporter.getInstance().createHtmlReporter(this.getName());
                HtmlReporter.getInstance().reset();
            }
            LevelLog.sDefaultLogger = new LevelLog();
        }
    }

    protected TransformContext getTransformContext(TransformInvocation transformInvocation) {
        return new TransformContext(transformInvocation, ((BaseContext)this.context).project, ((BaseContext)this.context).android, new TransformOptions.Builder().setPluginIncremental(this.isIncremental()).setShouldSaveCache(this.shouldSaveCache()).setUseRawCache(BooleanProperty.ENABLE_RAM_CACHE.value()).setUseFixedTimestamp(BooleanProperty.USE_FIXED_TIMESTAMP.value()).setForbidUseLenientMutationDuringGetArtifact(BooleanProperty.FORBID_USE_LENIENT_MUTATION_DURING_GET_ARTIFACT.value()).setAllowRewrite(BooleanProperty.ALLOW_REWRITE.value()).build());
    }

    protected void afterTransform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
    }

    protected void init(TransformContext transformContext) {
        LevelLog.sDefaultLogger = ((BaseContext)this.context).getLogger();
        if (BooleanProperty.ENABLE_HTML_LOG.value().booleanValue()) {
            String applicationId = "unknow";
            String versionName = "unknow";
            String versionCode = "unknow";
            ProductFlavor flavor = transformContext.getVariant().getMergedFlavor();
            if (flavor != null) {
                Integer flavorVersionCode;
                String flavorVersionName;
                String flavorApplicationId = flavor.getApplicationId();
                if (flavorApplicationId != null && !flavorApplicationId.isEmpty()) {
                    applicationId = flavorApplicationId;
                }
                if ((flavorVersionName = flavor.getVersionName()) != null && !flavorVersionName.isEmpty()) {
                    versionName = flavorVersionName;
                }
                if ((flavorVersionCode = flavor.getVersionCode()) != null) {
                    versionCode = String.valueOf(flavorVersionCode);
                }
            }
            HtmlReporter.getInstance().init(transformContext.byteXBuildDir().getAbsolutePath(), "ByteX", applicationId, versionName, versionCode);
        }
    }

    protected abstract List<IPlugin> getPlugins();

    private Set<TransformConfiguration> getConfigurations() {
        if (this.configurations == null) {
            this.configurations = this.getPlugins().stream().map(IPlugin::transformConfiguration).collect(Collectors.toSet());
        }
        return this.configurations;
    }
}

