/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.graph;

import com.ss.android.ugc.bytex.common.configuration.BooleanProperty;
import com.ss.android.ugc.bytex.common.exception.DuplicateClassException;
import com.ss.android.ugc.bytex.common.graph.ClassEntity;
import com.ss.android.ugc.bytex.common.graph.ClassNode;
import com.ss.android.ugc.bytex.common.graph.EditableGraph;
import com.ss.android.ugc.bytex.common.graph.Graph;
import com.ss.android.ugc.bytex.common.graph.InterfaceNode;
import com.ss.android.ugc.bytex.common.graph.Node;
import com.ss.android.ugc.bytex.common.log.LevelLog;
import com.ss.android.ugc.bytex.transformer.TransformContext;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class GraphBuilder {
    protected Map<String, Node> nodeMap = new ConcurrentHashMap<String, Node>(0);
    private volatile Graph graph;

    public GraphBuilder(TransformContext context2) {
    }

    public GraphBuilder() {
    }

    public boolean isCacheValid() {
        return false;
    }

    public void add(ClassEntity entity) {
        this.add(entity, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ClassEntity entity, boolean fromCache) {
        Node current = this.getOrPutEmpty((entity.access & 0x200) != 0, entity.name);
        if (!current.defined.compareAndSet(false, true)) {
            if (fromCache) {
                return;
            }
            if (!entity.fromAndroid && !this.isCacheValid()) {
                String msg = String.format("We found duplicate %s class files in the project.", current.entity.name);
                if (BooleanProperty.ENABLE_DUPLICATE_CLASS_CHECK.value().booleanValue() && !"module-info".equals(current.entity.name)) {
                    throw new DuplicateClassException(msg);
                }
                LevelLog.sDefaultLogger.e(msg);
            }
        }
        ClassNode superNode = null;
        List interfaceNodes = Collections.emptyList();
        if (entity.superName != null) {
            Node node = this.getOrPutEmpty(false, entity.superName);
            if (node instanceof ClassNode) {
                superNode = (ClassNode)node;
                if (current instanceof ClassNode) {
                    ClassNode classNode = superNode;
                    synchronized (classNode) {
                        if (superNode.children == Collections.EMPTY_LIST) {
                            superNode.children = new LinkedList<ClassNode>();
                        }
                        superNode.children.add((ClassNode)current);
                    }
                }
            } else {
                throw new RuntimeException(String.format("%s is not a class. Maybe there are duplicate class files in the project.", entity.superName));
            }
        }
        if (entity.interfaces.size() > 0) {
            interfaceNodes = entity.interfaces.stream().map(i -> {
                Node node = this.getOrPutEmpty(true, (String)i);
                if (node instanceof InterfaceNode) {
                    InterfaceNode interfaceNode;
                    InterfaceNode interfaceNode2 = interfaceNode = (InterfaceNode)node;
                    synchronized (interfaceNode2) {
                        if (current instanceof InterfaceNode) {
                            if (interfaceNode.children == Collections.EMPTY_LIST) {
                                interfaceNode.children = new LinkedList<InterfaceNode>();
                            }
                            interfaceNode.children.add((InterfaceNode)current);
                        } else if (current instanceof ClassNode) {
                            if (interfaceNode.implementedClasses == Collections.EMPTY_LIST) {
                                interfaceNode.implementedClasses = new LinkedList<ClassNode>();
                            }
                            interfaceNode.implementedClasses.add((ClassNode)current);
                        }
                    }
                    return (InterfaceNode)node;
                }
                throw new RuntimeException(String.format("%s is not a interface. Maybe there are duplicate class files in the project.", i));
            }).collect(Collectors.toList());
        }
        current.entity = entity;
        current.parent = superNode;
        current.interfaces = interfaceNodes;
    }

    private Node getOrPutEmpty(boolean isInterface, String className) {
        return this.nodeMap.computeIfAbsent(className, n -> isInterface ? new InterfaceNode((String)n) : new ClassNode((String)n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graph build() {
        if (this.graph == null) {
            GraphBuilder graphBuilder = this;
            synchronized (graphBuilder) {
                if (this.graph == null) {
                    this.graph = new EditableGraph((Map<String, ? extends Node>)this.nodeMap);
                }
            }
        }
        return this.graph;
    }
}

