/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.hook;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.AppExtension;
import com.ss.android.ugc.bytex.common.BaseContext;
import com.ss.android.ugc.bytex.common.ByteXExtension;
import com.ss.android.ugc.bytex.common.CommonTransform;
import com.ss.android.ugc.bytex.common.IPlugin;
import com.ss.android.ugc.bytex.common.configuration.BooleanProperty;
import com.ss.android.ugc.bytex.transformer.TransformContext;
import com.ss.android.ugc.bytex.transformer.TransformOptions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;

public class ProxyTransform
extends CommonTransform<BaseContext> {
    private List<IPlugin> plugins = new ArrayList<IPlugin>();
    private final Transform origTransform;

    ProxyTransform(Project project, AppExtension android, String transformName, Transform origTransform) {
        super(new BaseContext<1>(project, android, new ByteXExtension(){

            @Override
            public String getName() {
                return "hook";
            }
        }));
        this.origTransform = origTransform;
    }

    @Override
    protected TransformContext getTransformContext(TransformInvocation transformInvocation) {
        return new ProxyTransformContext(transformInvocation, this.context.getProject(), this.context.getAndroid(), new TransformOptions.Builder().setPluginIncremental(this.isIncremental()).setShouldSaveCache(this.shouldSaveCache()).setUseRawCache(BooleanProperty.ENABLE_RAM_CACHE.value()).setUseFixedTimestamp(BooleanProperty.USE_FIXED_TIMESTAMP.value()).setForbidUseLenientMutationDuringGetArtifact(BooleanProperty.FORBID_USE_LENIENT_MUTATION_DURING_GET_ARTIFACT.value()).setAllowRewrite(BooleanProperty.ALLOW_REWRITE.value()).build());
    }

    @Override
    protected void afterTransform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        super.afterTransform(transformInvocation);
        this.context.getLogger().i("Start to execute " + this.origTransform.getClass());
        this.origTransform.transform(transformInvocation);
        this.context.getLogger().i("Finish to execute " + this.origTransform.getClass());
    }

    @Override
    public String getName() {
        return this.origTransform.getName();
    }

    void appendPlugin(IPlugin plugin) {
        this.plugins.add(plugin);
    }

    @Override
    protected List<IPlugin> getPlugins() {
        return this.plugins;
    }

    @Override
    public Set<QualifiedContent.ContentType> getInputTypes() {
        return this.origTransform.getInputTypes();
    }

    @Override
    public Set<? super QualifiedContent.Scope> getScopes() {
        return this.origTransform.getScopes();
    }

    private static class ProxyTransformContext
    extends TransformContext {
        public ProxyTransformContext(TransformInvocation invocation, Project project, AppExtension android, TransformOptions transformOptions) {
            super(invocation, project, android, transformOptions);
        }

        @Override
        public File getOutputFile(QualifiedContent content) throws IOException {
            return content.getFile();
        }

        @Override
        public File getOutputFile(QualifiedContent content, boolean createIfNeed) throws IOException {
            return content.getFile();
        }
    }
}

