/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.log.Impl;

import com.ss.android.ugc.bytex.common.log.Impl.CachedLogger;
import com.ss.android.ugc.bytex.common.log.html.HtmlFragmentProvider;
import com.ss.android.ugc.bytex.common.utils.CalendarUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Triple;
import org.gradle.api.logging.LogLevel;

public class HtmlLoggerImpl
extends CachedLogger
implements HtmlFragmentProvider {
    private String moduleName;

    public HtmlLoggerImpl(String moduleName) {
        this.moduleName = moduleName;
    }

    @Override
    public synchronized void provideHtmlCode(Appendable appendable) throws IOException {
        appendable.append("<li>\n").append(String.format("%s Check Results:E(%s),W(%s),I(%s),D(%s)", this.moduleName, this.getSize(LogLevel.ERROR), this.getSize(LogLevel.WARN), this.getSize(LogLevel.INFO), this.getSize(LogLevel.DEBUG))).append("</li>\n");
        HtmlLoggerImpl.getExpandableCodeString(appendable, "Click To Expend for details", this::getTable);
    }

    @Override
    public void reset() {
        this.clear();
    }

    private void getTable(Appendable appendable) throws IOException {
        Map debug;
        Map info;
        Map warn;
        appendable.append("<table border=\"1\" cellpadding=\"8\">").append("<tr>").append("<th>").append("Module").append("</th>").append("<th>").append("Time").append("</th>").append("<th>").append("Level").append("</th>").append("<th>").append("Tag").append("</th>").append("<th>").append("Info").append("</th>").append("</tr>");
        Map error = (Map)this.logs.get(LogLevel.ERROR);
        boolean needAppendModuleName = true;
        if (error != null) {
            this.appendLevelLog(appendable, true, "ERROR", "ERROR", error);
            needAppendModuleName = false;
        }
        if ((warn = (Map)this.logs.get(LogLevel.WARN)) != null) {
            this.appendLevelLog(appendable, needAppendModuleName, "WARNING", "WARN", warn);
            needAppendModuleName = false;
        }
        if ((info = (Map)this.logs.get(LogLevel.INFO)) != null) {
            this.appendLevelLog(appendable, needAppendModuleName, "INFO", "INFO", info);
            needAppendModuleName = false;
        }
        if ((debug = (Map)this.logs.get(LogLevel.DEBUG)) != null) {
            this.appendLevelLog(appendable, needAppendModuleName, "DEBUG", "DEBUG", debug);
        }
        appendable.append("</table>");
    }

    private void appendLevelLog(Appendable appendable, boolean needAppendModuleName, String ssc, String levelName, Map<String, List<Triple<String, Throwable, Long>>> levelLogs) throws IOException {
        for (String key : levelLogs.keySet()) {
            List<Triple<String, Throwable, Long>> value = levelLogs.get(key);
            for (Triple<String, Throwable, Long> triple : value) {
                appendable.append("<tr>");
                if (needAppendModuleName) {
                    appendable.append("<td").append(" rowspan=\"").append(String.valueOf(this.getTotalRows())).append("\"").append(">").append(this.moduleName).append("</td>");
                    needAppendModuleName = false;
                }
                appendable.append("<td").append(" class=\"").append(ssc).append("\">").append(CalendarUtils.getDateAndTimeString((Long)triple.getThird(), true)).append("</td>");
                appendable.append("<td").append(" class=\"").append(ssc).append("\">").append(levelName).append("</td>");
                appendable.append("<td").append(" class=\"").append(ssc).append("\">").append(key).append("</td>");
                if (triple.getSecond() != null) {
                    appendable.append("<td").append(" class=\"").append(ssc).append("\">").append("<p>");
                    HtmlLoggerImpl.getExpandableCodeString(appendable, (String)triple.getFirst(), appendable1 -> {
                        StringWriter stackTraceHolder = new StringWriter();
                        ((Throwable)triple.getSecond()).printStackTrace(new PrintWriter(stackTraceHolder));
                        appendable1.append(stackTraceHolder.toString());
                    });
                    appendable.append("</p></td>");
                } else {
                    appendable.append("<td").append(" class=\"").append(ssc).append("\">").append((CharSequence)triple.getFirst()).append("</td>");
                }
                appendable.append("</tr>");
            }
        }
    }

    private int getTotalRows() {
        AtomicInteger size = new AtomicInteger();
        this.logs.keySet().stream().filter(it -> it == LogLevel.ERROR || it == LogLevel.WARN || it == LogLevel.INFO || it == LogLevel.DEBUG).flatMap(it -> ((Map)this.logs.get(it)).values().stream()).forEach(it -> size.addAndGet(it.size()));
        return size.get();
    }

    private int getSize(LogLevel logLevel) {
        AtomicInteger size = new AtomicInteger();
        this.logs.keySet().stream().filter(it -> it == logLevel).flatMap(it -> ((Map)this.logs.get(it)).values().stream()).forEach(it -> size.addAndGet(it.size()));
        return size.get();
    }

    private static void getExpandableCodeString(Appendable appendable, String title, Func1<Appendable> action) throws IOException {
        appendable.append("<details>\n").append("<summary>").append(title).append("</summary>\n").append("<pre><code>");
        action.apply(appendable);
        appendable.append("</code></pre>\n").append("</details>\n");
    }

    public static interface Func1<F> {
        public void apply(F var1) throws IOException;
    }

    public static interface Func4<F, S, T, FO> {
        public void apply(F var1, S var2, T var3, FO var4);
    }
}

