/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.log;

import com.ss.android.ugc.bytex.common.log.ILogger;

public class LevelLog
implements ILogger {
    public static ILogger sDefaultLogger = new LevelLog();
    private ILogger logger;
    private Level level = Level.INFO;

    public LevelLog() {
        this(ILogger.DEFAULT);
    }

    public LevelLog(ILogger logger) {
        this.setImpl(logger);
    }

    public void setLevel(Level l) {
        this.level = l;
    }

    public void setImpl(ILogger l) {
        this.logger = l;
    }

    public ILogger getImpl() {
        return this.logger;
    }

    @Override
    public void setTag(String tag) {
        this.logger.setTag(tag);
    }

    @Override
    public void d(String msg) {
        if (this.level.compareTo(Level.DEBUG) <= 0) {
            this.logger.d(msg);
        }
    }

    @Override
    public void d(String tag, String msg) {
        if (this.level.compareTo(Level.DEBUG) <= 0) {
            this.logger.d(tag, msg);
        }
    }

    @Override
    public void i(String msg) {
        if (this.level.compareTo(Level.INFO) <= 0) {
            this.logger.i(msg);
        }
    }

    @Override
    public void i(String tag, String msg) {
        if (this.level.compareTo(Level.INFO) <= 0) {
            this.logger.i(tag, msg);
        }
    }

    @Override
    public void w(String msg) {
        if (this.level.compareTo(Level.WARN) <= 0) {
            this.logger.w(msg);
        }
    }

    @Override
    public void w(String tag, String msg) {
        if (this.level.compareTo(Level.WARN) <= 0) {
            this.logger.w(tag, msg);
        }
    }

    @Override
    public void w(String msg, Throwable t) {
        if (this.level.compareTo(Level.WARN) <= 0) {
            this.logger.w(msg, t);
        }
    }

    @Override
    public void w(String tag, String msg, Throwable t) {
        if (this.level.compareTo(Level.WARN) <= 0) {
            this.logger.w(tag, msg, t);
        }
    }

    @Override
    public void e(String msg) {
        if (this.level.compareTo(Level.ERROR) <= 0) {
            this.logger.e(msg);
        }
    }

    @Override
    public void e(String tag, String msg) {
        if (this.level.compareTo(Level.ERROR) <= 0) {
            this.logger.e(tag, msg);
        }
    }

    @Override
    public void e(String msg, Throwable t) {
        if (this.level.compareTo(Level.ERROR) <= 0) {
            this.logger.e(msg, t);
        }
    }

    @Override
    public void e(String tag, String msg, Throwable t) {
        if (this.level.compareTo(Level.ERROR) <= 0) {
            this.logger.e(tag, msg, t);
        }
    }

    public static enum Level {
        DEBUG("DEBUG"),
        INFO("INFO"),
        WARN("WARN"),
        ERROR("ERROR");

        String value;

        private Level(String value) {
            this.value = value;
        }
    }
}

