/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.processor;

import com.ss.android.ugc.bytex.common.exception.ByteXException;
import com.ss.android.ugc.bytex.common.exception.GlobalWhiteListManager;
import com.ss.android.ugc.bytex.common.flow.main.MainProcessHandler;
import com.ss.android.ugc.bytex.common.flow.main.Process;
import com.ss.android.ugc.bytex.common.log.LevelLog;
import com.ss.android.ugc.bytex.common.processor.MainProcessFileHandler;
import com.ss.android.ugc.bytex.common.utils.Utils;
import com.ss.android.ugc.bytex.common.verify.AsmVerifier;
import com.ss.android.ugc.bytex.common.verify.AsmVerifyClassVisitor;
import com.ss.android.ugc.bytex.common.visitor.ClassVisitorChain;
import com.ss.android.ugc.bytex.common.visitor.SafeClassNode;
import com.ss.android.ugc.bytex.transformer.TransformContext;
import com.ss.android.ugc.bytex.transformer.cache.FileData;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class ClassFileTransformer
extends MainProcessFileHandler {
    private boolean needPreVerify;
    private boolean needVerify;
    private TransformContext context;

    @Deprecated
    public ClassFileTransformer(List<MainProcessHandler> handlers, boolean needPreVerify, boolean needVerify) {
        this(null, handlers, needPreVerify, needVerify);
    }

    public ClassFileTransformer(TransformContext context2, List<MainProcessHandler> handlers, boolean needPreVerify, boolean needVerify) {
        super(handlers);
        this.context = context2;
        this.needPreVerify = needPreVerify;
        this.needVerify = needVerify;
    }

    @Override
    public void handle(FileData fileData) {
        block10: {
            try {
                byte[] raw = fileData.getBytes();
                String relativePath = fileData.getRelativePath();
                int cwFlags = 0;
                int crFlags = 0;
                for (MainProcessHandler handler : this.handlers) {
                    cwFlags |= handler.flagForClassWriter();
                    if ((handler.flagForClassReader(Process.TRANSFORM) & 8) != 8) continue;
                    crFlags |= 8;
                }
                ClassReader cr = new ClassReader(raw);
                ClassWriter cw = new ClassWriter(cwFlags);
                ClassVisitorChain chain = this.getClassVisitorChain(relativePath);
                if (this.needPreVerify) {
                    chain.connect(new AsmVerifyClassVisitor());
                }
                if (this.handlers != null && !this.handlers.isEmpty()) {
                    for (Object handler : this.handlers) {
                        if (handler.transform(relativePath, chain)) continue;
                        fileData.delete();
                        return;
                    }
                }
                SafeClassNode cn = new SafeClassNode();
                chain.append(cn);
                chain.accept(cr, crFlags);
                for (MainProcessHandler handler : this.handlers) {
                    if (handler.transform(relativePath, cn)) continue;
                    fileData.delete();
                    return;
                }
                cn.accept((ClassVisitor)cw);
                raw = cw.toByteArray();
                if (this.needVerify) {
                    ClassNode verifyNode = new ClassNode();
                    new ClassReader(raw).accept((ClassVisitor)verifyNode, crFlags);
                    AsmVerifier.verify(verifyNode);
                }
                fileData.setBytes(raw);
            }
            catch (ByteXException e) {
                throw e;
            }
            catch (Exception e) {
                LevelLog.sDefaultLogger.e(String.format("Failed to handle class %s", fileData.getRelativePath()), e);
                if (GlobalWhiteListManager.INSTANCE.shouldIgnore(fileData.getRelativePath())) break block10;
                if (this.context != null) {
                    throw new RuntimeException(String.format("%s\n\tFailed to resolve class %s[%s]", e.getMessage(), fileData.getRelativePath(), Utils.getAllFileCachePath(this.context, fileData.getRelativePath())), e);
                }
                throw e;
            }
        }
    }
}

