/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.utils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class CalendarUtils {
    private static final String TAG = "CalendarUtils";
    private static final String TIME_FORMAT_24H = "HH:mm:ss";
    private static final String TIME_FORMAT_12H = "K:mm:ss a";
    private static final String DATE_FORMAT_NO_YEAR = "MMM d, HH:mm";
    private static final String DEFAULT_SEPARATOR = ", ";

    public static String getDateAndTimeString(long millis, boolean alwaysShowDate) {
        StringBuilder sb = new StringBuilder();
        if (alwaysShowDate) {
            sb.append(CalendarUtils.getDateString(millis));
            sb.append(DEFAULT_SEPARATOR);
        }
        sb.append(CalendarUtils.getTimeString(true, millis));
        return sb.toString();
    }

    public static String getDateString(long millis) {
        if (millis < 0L) {
            return null;
        }
        Calendar currCal = Calendar.getInstance();
        currCal.setTimeInMillis(millis);
        return DateFormat.getDateInstance().format(currCal.getTime());
    }

    public static String getTimeString(boolean is24h, long millis) {
        if (millis < 0L) {
            return null;
        }
        Calendar targetCal = Calendar.getInstance();
        targetCal.setTimeInMillis(millis);
        SimpleDateFormat sdf = new SimpleDateFormat(is24h ? TIME_FORMAT_24H : TIME_FORMAT_12H, Locale.US);
        return sdf.format(targetCal.getTime());
    }
}

