/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.xml;

import com.ss.android.ugc.bytex.common.log.LevelLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class XmlReader {
    private final SAXReader reader = new SAXReader();

    public void read(String filePath, Visitor visitor) {
        File file = new File(filePath);
        this.read(file, Collections.singletonList(visitor));
    }

    public void read(File file, Visitor visitor) {
        this.read(file, Collections.singletonList(visitor));
    }

    public void read(String filePath, List<Visitor> visitors) {
        File file = new File(filePath);
        this.read(file, visitors);
    }

    public void read(File file, List<Visitor> visitors) {
        try {
            this.readWithoutCatchException(new FileInputStream(file), visitors);
        }
        catch (FileNotFoundException | DocumentException e) {
            LevelLog.sDefaultLogger.e(e.getMessage(), e);
        }
    }

    public void readWithoutCatchException(InputStream is, List<Visitor> visitors) throws DocumentException {
        Document document = this.reader.read(new InputSource(is));
        Element root = document.getRootElement();
        this.readNode(root, visitors);
    }

    private void readNode(Element node, List<Visitor> visitors) {
        if (visitors == null || visitors.isEmpty()) {
            return;
        }
        String nodeName = node.getTextTrim().isEmpty() ? node.getName() : node.getTextTrim();
        List attributes = node.attributes();
        LinkedList<Visitor> visitElementVisitors = new LinkedList<Visitor>();
        for (Visitor visitor : visitors) {
            if (!visitor.visitNode(node.getQualifiedName(), nodeName, attributes)) continue;
            visitElementVisitors.add(visitor);
        }
        if (visitElementVisitors.isEmpty()) {
            return;
        }
        List elements = node.elements();
        for (Element e : elements) {
            this.readNode(e, visitElementVisitors);
        }
    }

    public static interface Visitor {
        public boolean visitNode(String var1, String var2, List<Attribute> var3);
    }
}

