/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.transformer;

import bytex.core.patch.AGPStub;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.BaseVariant;
import com.google.common.base.Joiner;
import com.ss.android.ugc.bytex.gradletoolkit.Artifact;
import com.ss.android.ugc.bytex.gradletoolkit.GradleEnv;
import com.ss.android.ugc.bytex.gradletoolkit.TransformEnv;
import com.ss.android.ugc.bytex.transformer.TransformInputs;
import com.ss.android.ugc.bytex.transformer.TransformOptions;
import com.ss.android.ugc.bytex.transformer.TransformOutputs;
import com.ss.android.ugc.bytex.transformer.cache.DirCache;
import com.ss.android.ugc.bytex.transformer.cache.FileCache;
import com.ss.android.ugc.bytex.transformer.cache.FileData;
import com.ss.android.ugc.bytex.transformer.cache.JarCache;
import com.ss.android.ugc.bytex.transformer.internal.TransformEnvWithNoLenientMutationImpl;
import com.ss.android.ugc.bytex.transformer.io.ClassFinder;
import com.ss.android.ugc.bytex.transformer.io.ClassNodeLoader;
import com.ss.android.ugc.bytex.transformer.location.Locator;
import com.ss.android.ugc.bytex.transformer.utils.Service;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.launcher.daemon.server.scaninfo.DaemonScanInfo;
import org.objectweb.asm.tree.ClassNode;

public class TransformContext
implements GradleEnv,
ClassFinder {
    private TransformInvocation invocation;
    private TransformEnv transformEnv;
    private Locator locator;
    private TransformInputs transformInputs;
    private TransformOutputs transformOutputs;
    protected Project project;
    protected AppExtension android;
    private TransformOptions transformOptions;
    private boolean hasRequestNotIncremental = false;
    private File graphCacheFile;
    private String temporaryDirName;
    private ClassFinder finder;
    private State state = State.STATELESS;

    @Deprecated
    public TransformContext(TransformInvocation invocation, Project project, AppExtension android, boolean isPluginIncremental) {
        this(invocation, project, android, isPluginIncremental, true);
    }

    @Deprecated
    public TransformContext(TransformInvocation invocation, Project project, AppExtension android, boolean isPluginIncremental, boolean shouldSaveCache) {
        this(invocation, project, android, isPluginIncremental, shouldSaveCache, false);
    }

    @Deprecated
    public TransformContext(TransformInvocation invocation, Project project, AppExtension android, boolean isPluginIncremental, boolean shouldSaveCache, boolean useRawCache) {
        this(invocation, project, android, new TransformOptions.Builder().setPluginIncremental(isPluginIncremental).setShouldSaveCache(shouldSaveCache).setUseRawCache(useRawCache).build());
    }

    public TransformContext(TransformInvocation invocation, Project project, AppExtension android, TransformOptions transformOptions) {
        this.invocation = invocation;
        this.project = project;
        this.android = android;
        this.transformOptions = transformOptions;
        this.transformEnv = Service.load(TransformEnv.class);
        if (this.transformEnv != null) {
            if (transformOptions.isForbidUseLenientMutationDuringGetArtifact()) {
                this.transformEnv = new TransformEnvWithNoLenientMutationImpl(this.transformEnv);
            }
            this.transformEnv.setProject(project);
            this.transformEnv.setTransformInvocation(invocation);
        }
        this.temporaryDirName = invocation.getContext().getTemporaryDir().getName();
        this.temporaryDirName = this.temporaryDirName.replace("transformClassesAndResourcesWith", "");
        this.temporaryDirName = this.temporaryDirName.replace("transformClassesWith", "");
        this.graphCacheFile = new File(this.byteXBuildDir(), "graphCache.json");
        this.locator = new Locator(this);
        this.transformOutputs = new TransformOutputs(this, invocation, new File(this.byteXBuildDir(), "outputs.txt"), transformOptions);
        this.transformInputs = new TransformInputs(this, invocation, new File(this.byteXBuildDir(), "inputs.txt"), transformOptions);
        this.finder = new ClassNodeLoader(this);
    }

    public TransformInputs getTransformInputs() {
        return this.transformInputs;
    }

    public Collection<DirCache> getAllDirs() {
        return this.transformInputs.getAllDirs();
    }

    public Collection<JarCache> getAllJars() {
        return this.transformInputs.getAllJars();
    }

    public Stream<FileCache> allFiles() {
        return this.transformInputs.allFiles();
    }

    public TransformOutputs getTransformOutputs() {
        return this.transformOutputs;
    }

    public File getOutputFile(QualifiedContent content) throws IOException {
        return this.transformOutputs.getOutputFile(content);
    }

    public File getOutputFile(QualifiedContent content, boolean createIfNeed) throws IOException {
        return this.transformOutputs.getOutputFile(content, createIfNeed);
    }

    public static File getOutputTarget(File root, String relativePath) throws IOException {
        return TransformOutputs.getOutputTarget(root, relativePath);
    }

    public File getOutputDir(String affinity) throws IOException {
        return this.transformOutputs.getOutputDir(affinity);
    }

    public boolean isIncremental() {
        return this.invocation.isIncremental() && this.getTransformOptions().isPluginIncremental() && !this.hasRequestNotIncremental;
    }

    public boolean shouldSaveCache() {
        return this.getTransformOptions().isShouldSaveCache();
    }

    public TransformOptions getTransformOptions() {
        return this.transformOptions;
    }

    public void requestNotIncremental() {
        if (this.state.compareTo(State.RUNNING) >= 0) {
            throw new RuntimeException("You Should request for not incremental before traversing.");
        }
        if (!this.isIncremental()) {
            return;
        }
        this.transformInputs.requestNotIncremental();
        this.hasRequestNotIncremental = true;
    }

    public boolean requestNotIncremental(String relativePath) {
        if (this.state.compareTo(State.RUNNING) >= 0) {
            throw new RuntimeException("You Should request for not incremental before traversing.");
        }
        if (!this.isIncremental()) {
            return false;
        }
        return this.transformInputs.requestNotIncremental(relativePath);
    }

    public boolean isReleaseBuild() {
        return this.invocation.getContext().getVariantName().toLowerCase().contains("release");
    }

    public TransformInvocation getInvocation() {
        return this.invocation;
    }

    public String getVariantName() {
        return this.invocation.getContext().getVariantName();
    }

    public BaseVariant getVariant() {
        return AGPStub.getVariant(this.invocation, this.project);
    }

    public File androidJar() throws FileNotFoundException {
        File jar = this.transformOptions.getAndroidJarProvider().getAndroidJar(this.project, this.android);
        if (jar == null || !jar.exists()) {
            throw new FileNotFoundException("Android jar not found!");
        }
        return jar;
    }

    public File byteXBuildDir() {
        return new File(new File(this.project.getBuildDir(), "ByteX"), this.temporaryDirName);
    }

    @Override
    @Nonnull
    public Collection<File> getArtifact(@Nonnull Artifact artifact) {
        return this.transformEnv.getArtifact(artifact);
    }

    void addFile(String affinity, FileData file) {
        this.transformInputs.addFile(affinity, file);
    }

    public List<FileData> getChangedFiles() {
        if (this.isIncremental()) {
            return this.transformInputs.getChangedFiles();
        }
        return Collections.emptyList();
    }

    public Locator getLocator() {
        return this.locator;
    }

    @Deprecated
    public File getGraphCache() {
        return this.graphCacheFile;
    }

    synchronized void markRunningState(State state) {
        this.state = state;
    }

    public boolean isDaemonSingleUse() {
        try {
            return ((DaemonScanInfo)((ProjectInternal)this.project).getServices().get(DaemonScanInfo.class)).isSingleUse();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public File getProguardMappingFile() {
        BaseVariant variant = AGPStub.getVariant(this.invocation, this.project);
        return new File(Joiner.on((char)File.separatorChar).join((Object)String.valueOf(this.project.getBuildDir()), (Object)"outputs", new Object[]{"mapping", variant.getFlavorName(), variant.getBuildType().getName(), "mapping.txt"}));
    }

    public void release() {
        this.transformInputs.saveCache();
        this.transformInputs.release();
        this.transformInputs = null;
        this.transformOutputs.saveCache();
        this.transformOutputs.release();
        this.transformOutputs = null;
        this.invocation = null;
        this.transformEnv = null;
        this.locator = null;
        this.project = null;
        this.android = null;
        this.graphCacheFile = null;
        this.temporaryDirName = null;
        this.transformOptions = null;
        this.finder = null;
        this.hasRequestNotIncremental = false;
    }

    @Override
    public ClassNode find(String className, int parsingOption) {
        if (this.finder != null) {
            return this.finder.find(className, parsingOption);
        }
        return null;
    }

    @Override
    public ClassNode find(String className) {
        return this.find(className, 2);
    }

    @Override
    public Class<?> loadClass(String className) {
        if (this.finder != null) {
            return this.finder.loadClass(className);
        }
        return null;
    }

    public static enum State implements Comparable<State>
    {
        STATELESS,
        INITIALIZING,
        INITIALIZED,
        INCREMENTALTRAVERSING,
        BEFORETRAVERSE,
        RUNNING,
        TRAVERSING,
        TRAVERSINGANDROID,
        BEFORETRANSFORM,
        TRANSFORMING,
        AFTERTRANSFORM;

    }
}

