/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.transformer;

import com.android.build.api.transform.Status;
import com.ss.android.ugc.bytex.transformer.TransformContext;
import com.ss.android.ugc.bytex.transformer.cache.FileData;
import com.ss.android.ugc.bytex.transformer.cache.JarCache;
import com.ss.android.ugc.bytex.transformer.concurrent.Schedulers;
import com.ss.android.ugc.bytex.transformer.concurrent.Worker;
import com.ss.android.ugc.bytex.transformer.processor.BackupFileProcessor;
import com.ss.android.ugc.bytex.transformer.processor.FileProcessor;
import com.ss.android.ugc.bytex.transformer.processor.task.PerformTransformTask;
import com.ss.android.ugc.bytex.transformer.processor.task.PerformTraverseTask;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class TransformEngine {
    private TransformContext context;

    public TransformEngine(TransformContext context2) {
        this.context = context2;
    }

    public void markRunningState(TransformContext.State state) {
        this.context.markRunningState(state);
    }

    public void transform(FileProcessor ... processors) {
        this.transform(false, processors);
    }

    public void transform(boolean isLast, FileProcessor ... processors) {
        Schedulers.FORKJOINPOOL().invoke(new PerformTransformTask(this.context.allFiles(), TransformEngine.getProcessorList(processors), isLast, this.context));
    }

    public void skip() throws IOException {
        Worker worker = Schedulers.IO();
        this.context.allFiles().map(f -> () -> {
            f.skip();
            return null;
        }).forEach(worker::submit);
        worker.await();
    }

    public void transformOutput() throws IOException {
        Worker worker = Schedulers.IO();
        this.context.allFiles().filter(fileCache -> !fileCache.isHasWritten()).map(f -> () -> {
            f.transformOutput();
            return null;
        }).forEach(worker::submit);
        worker.await();
    }

    public void traverseOnly(FileProcessor ... processors) {
        Schedulers.FORKJOINPOOL().invoke(new PerformTraverseTask(this.context.allFiles(), TransformEngine.getProcessorList(processors)));
    }

    public void traverseAndroidJar(File jar, FileProcessor ... processors) {
        Schedulers.FORKJOINPOOL().invoke(new PerformTraverseTask(Stream.of(new JarCache(jar, this.context.isIncremental() ? Status.NOTCHANGED : Status.ADDED, this.context)), TransformEngine.getProcessorList(processors)));
    }

    private static List<FileProcessor> getProcessorList(FileProcessor[] processors) {
        ArrayList<FileProcessor> realProcessorList = new ArrayList<FileProcessor>(processors.length + 1);
        Collections.addAll(realProcessorList, processors);
        realProcessorList.add(new BackupFileProcessor());
        return realProcessorList;
    }

    public TransformContext getContext() {
        return this.context;
    }

    public void addFile(String affinity, FileData file) {
        this.context.addFile(affinity, file);
    }
}

