/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.transformer.cache;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.utils.FileUtils;
import com.google.common.io.Files;
import com.ss.android.ugc.bytex.transformer.TransformContext;
import com.ss.android.ugc.bytex.transformer.TransformOutputs;
import com.ss.android.ugc.bytex.transformer.cache.FileCache;
import com.ss.android.ugc.bytex.transformer.cache.FileData;
import com.ss.android.ugc.bytex.transformer.io.Files_;
import io.reactivex.ObservableEmitter;
import io.reactivex.functions.Consumer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DirCache
extends FileCache {
    protected final File dir;
    protected final File outputFile;

    public DirCache(QualifiedContent content, TransformContext context2) {
        super(content, context2);
        this.dir = content.getFile();
        try {
            this.outputFile = context2.getOutputFile(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DirCache(File dir, File outputFile, TransformContext context2) {
        super(null, context2);
        this.dir = dir;
        this.outputFile = outputFile;
    }

    @Override
    public File getFile() {
        return this.dir;
    }

    @Override
    public final synchronized void transformOutput(Consumer<FileData> visitor) throws IOException {
        this.output();
        HashMap entryMap = new HashMap();
        String relativeToProject = this.context.getTransformOutputs().relativeToProject(this.outputFile);
        TransformOutputs.Entry entry = this.context.getTransformOutputs().getLastTransformOutputs().get(relativeToProject);
        if (entry != null) {
            entry.traverseAll(e -> entryMap.put(e.getPath(), e));
        }
        List entries = Collections.synchronizedList(new LinkedList());
        this.parallelForEach(false, (Consumer<FileData>)((Consumer)item -> {
            if (visitor != null) {
                visitor.accept(item);
            }
            entries.add(this.transformOutput(this.context.getTransformOutputs().relativeToProject(new File(this.getFile(), item.getRelativePath())), relativeToProject, (FileData)item, entryMap));
        }));
        Collections.sort(entries);
        this.context.getTransformOutputs().getTransformOutputs().put(relativeToProject, new TransformOutputs.Entry(this.context.getTransformOutputs().relativeToProject(this.getFile()), relativeToProject, 0L, Collections.unmodifiableList(entries)));
    }

    private TransformOutputs.Entry transformOutput(String input, String parent, FileData fileData, Map<String, TransformOutputs.Entry> entryMap) throws IOException {
        String relativePath = fileData.getRelativePath();
        String absolutePath = parent + "/" + fileData.getRelativePath();
        TransformOutputs.Entry entry = entryMap.get(relativePath);
        long hash = entry == null ? Long.MAX_VALUE : entry.getHash();
        File target = TransformContext.getOutputTarget(this.outputFile, fileData.getRelativePath());
        if (fileData.getStatus() == Status.REMOVED) {
            FileUtils.deleteIfExists((File)target);
        } else if (fileData.getStatus() != Status.NOTCHANGED) {
            if (fileData.contentLoaded()) {
                byte[] bytes = fileData.getBytes();
                if (bytes != null && bytes.length > 0) {
                    hash = TransformOutputs.Entry.Companion.hash(bytes);
                    if (!target.exists() || entry == null || hash != entry.getHash()) {
                        if (!target.exists()) {
                            Files.createParentDirs((File)target);
                        }
                        Files.write((byte[])bytes, (File)target);
                    }
                } else {
                    FileUtils.deleteIfExists((File)target);
                }
            } else {
                FileUtils.copyFile((File)new File(this.getFile(), fileData.getRelativePath()), (File)target);
            }
        }
        if (!target.exists()) {
            hash = Long.MAX_VALUE;
        } else if (hash == Long.MAX_VALUE) {
            hash = TransformOutputs.Entry.Companion.hash(target);
        }
        List attachments = Collections.synchronizedList(new LinkedList());
        fileData.traverseAttachmentOnly(attachment -> {
            try {
                attachments.add(this.transformOutput(null, absolutePath, (FileData)attachment, entryMap));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        Collections.sort(attachments);
        return new TransformOutputs.Entry(input, relativePath, hash, Collections.unmodifiableList(attachments));
    }

    @Override
    protected List<FileData> resolve(ObservableEmitter<FileData> emitter) throws IOException {
        URI base = this.getFile().toURI();
        ArrayList<FileData> dataList = new ArrayList<FileData>();
        if (this.context.getInvocation().isIncremental()) {
            FileData.LoadFunction loadFunction = fileData -> {
                try {
                    return Files.toByteArray((File)new File(this.getFile(), fileData.getRelativePath()));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
            Set allFiles = Files_.fileTreeTraverser().preOrderTraversal((Object)this.getFile()).stream().filter(File::isFile).filter(file -> !file.getName().equalsIgnoreCase(".DS_Store")).map(file -> base.relativize(file.toURI()).toString()).collect(Collectors.toSet());
            for (Map.Entry entry : ((DirectoryInput)this.content).getChangedFiles().entrySet()) {
                FileData data;
                File file2 = (File)entry.getKey();
                if (file2.isDirectory() || file2.getName().equalsIgnoreCase(".DS_Store")) continue;
                String relativePath = base.relativize(file2.toURI()).toString();
                FileData fileData2 = data = entry.getValue() == Status.REMOVED ? new FileData((byte[])null, relativePath, (Status)entry.getValue()) : new FileData(loadFunction, relativePath, (Status)entry.getValue());
                if (entry.getValue() == Status.REMOVED && new File(this.outputFile, data.getRelativePath()).isDirectory()) continue;
                if (emitter != null) {
                    emitter.onNext((Object)data);
                }
                dataList.add(data);
                allFiles.remove(relativePath);
            }
            for (String file3 : allFiles) {
                FileData data = new FileData(loadFunction, file3, Status.NOTCHANGED);
                if (emitter != null) {
                    emitter.onNext((Object)data);
                }
                dataList.add(data);
            }
        } else {
            for (File file4 : Files_.fileTreeTraverser().preOrderTraversal((Object)this.getFile())) {
                if (!file4.isFile() || file4.getName().equalsIgnoreCase(".DS_Store")) continue;
                FileData data = new FileData(Files.toByteArray((File)file4), base.relativize(file4.toURI()).toString(), Status.ADDED);
                if (emitter != null) {
                    emitter.onNext((Object)data);
                }
                dataList.add(data);
            }
        }
        return dataList;
    }

    @Override
    public synchronized void skip() throws IOException {
        this.output();
        FileUtils.copyDirectory((File)this.getFile(), (File)this.outputFile);
    }
}

