/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.transformer.cache;

import com.ss.android.ugc.bytex.transformer.TransformContext;
import com.ss.android.ugc.bytex.transformer.cache.DirCache;
import com.ss.android.ugc.bytex.transformer.cache.FileData;
import io.reactivex.ObservableEmitter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NewFileCache
extends DirCache {
    private final String affinity;

    public NewFileCache(TransformContext context2, String affinity) {
        this(new ArrayList<FileData>(), affinity, context2);
    }

    public NewFileCache(List<FileData> newFiles, String affinity, TransformContext context2) {
        super(new File(affinity), NewFileCache.getOutput(context2, affinity), context2);
        this.files = Collections.synchronizedList(newFiles);
        this.hasRead = true;
        this.affinity = affinity;
    }

    @Override
    protected List<FileData> resolve(ObservableEmitter<FileData> emitter) throws IOException {
        return Collections.unmodifiableList(this.files);
    }

    @Override
    public void skip() throws IOException {
        this.transformOutput();
    }

    @Override
    public List<FileData> getChangedFiles() {
        if (this.context.isIncremental()) {
            return Collections.unmodifiableList(this.files);
        }
        return Collections.emptyList();
    }

    public void addFile(FileData file) {
        if (this.isHasWritten()) {
            throw new RuntimeException("can not add file after FileCache has been outputed");
        }
        this.files.add(file);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewFileCache that = (NewFileCache)o;
        return this.affinity != null ? this.affinity.equals(that.affinity) : that.affinity == null;
    }

    public int hashCode() {
        return this.affinity != null ? this.affinity.hashCode() : 0;
    }

    private static File getOutput(TransformContext context2, String affinity) {
        try {
            return context2.getOutputDir(affinity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

