/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.builder.internal;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ss.android.ugc.bytex.common.IPlugin;
import com.ss.android.ugc.bytex.common.builder.internal.DefaultByteXBuildListener;
import com.ss.android.ugc.bytex.common.builder.internal.PluginStatus;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\"\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000f0\u0013J\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/ss/android/ugc/bytex/common/builder/internal/BuildRecorder;", "", "()V", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "outputDir", "Ljava/io/File;", "transformInfoRecords", "Ljava/util/LinkedList;", "Lcom/ss/android/ugc/bytex/common/builder/internal/BuildRecorder$TransformInfoRecord;", "recordPluginStatuses", "", "pluginStatuses", "", "Lcom/ss/android/ugc/bytex/common/builder/internal/PluginStatus;", "recordTransform", "transformInfo", "Lcom/ss/android/ugc/bytex/common/builder/internal/DefaultByteXBuildListener$TransformInfo;", "", "Lcom/ss/android/ugc/bytex/common/IPlugin;", "start", "project", "Lorg/gradle/api/Project;", "stop", "TransformInfoRecord", "TransformEngine"})
public final class BuildRecorder {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private File outputDir;
    private final LinkedList<TransformInfoRecord> transformInfoRecords = new LinkedList();

    public final void start(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        File file = this.outputDir = new File(project.getBuildDir(), "ByteX/build");
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        file.mkdirs();
    }

    public final void recordTransform(@NotNull DefaultByteXBuildListener.TransformInfo transformInfo, @NotNull Map<IPlugin, PluginStatus> pluginStatuses) {
        Intrinsics.checkParameterIsNotNull((Object)transformInfo, (String)"transformInfo");
        Intrinsics.checkParameterIsNotNull(pluginStatuses, (String)"pluginStatuses");
        this.transformInfoRecords.add(new TransformInfoRecord(transformInfo, pluginStatuses));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recordPluginStatuses(@NotNull Collection<PluginStatus> pluginStatuses) {
        File file;
        Intrinsics.checkParameterIsNotNull(pluginStatuses, (String)"pluginStatuses");
        File file2 = this.outputDir;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        if (!(file = new File(file2, "pluginStatuses.json")).exists()) {
            file.getParentFile().mkdirs();
        }
        Closeable closeable = new FileWriter(file);
        boolean bl = false;
        Throwable throwable = null;
        try {
            FileWriter it = (FileWriter)closeable;
            boolean bl2 = false;
            this.gson.toJson((Object)CollectionsKt.sorted((Iterable)pluginStatuses), new TypeToken<List<? extends PluginStatus>>(){}.getType(), (Appendable)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        File file;
        File file2 = this.outputDir;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        if (!(file = new File(file2, "transformInfo.json")).exists()) {
            file.getParentFile().mkdirs();
        }
        Closeable closeable = new FileWriter(file);
        boolean bl = false;
        Throwable throwable = null;
        try {
            FileWriter it = (FileWriter)closeable;
            boolean bl2 = false;
            this.gson.toJson(this.transformInfoRecords, new TypeToken<List<? extends TransformInfoRecord>>(){}.getType(), (Appendable)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.transformInfoRecords.clear();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001:\u0001&B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bR\u0019\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\r\"\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0019\u0010\u001f\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\rR\u001a\u0010!\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0011\"\u0004\b#\u0010\u0013R\u0011\u0010$\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\r\u00a8\u0006'"}, d2={"Lcom/ss/android/ugc/bytex/common/builder/internal/BuildRecorder$TransformInfoRecord;", "", "transformInfo", "Lcom/ss/android/ugc/bytex/common/builder/internal/DefaultByteXBuildListener$TransformInfo;", "pluginStatuses", "", "Lcom/ss/android/ugc/bytex/common/IPlugin;", "Lcom/ss/android/ugc/bytex/common/builder/internal/PluginStatus;", "(Lcom/ss/android/ugc/bytex/common/builder/internal/DefaultByteXBuildListener$TransformInfo;Ljava/util/Map;)V", "className", "", "kotlin.jvm.PlatformType", "getClassName", "()Ljava/lang/String;", "endTime", "", "getEndTime", "()J", "setEndTime", "(J)V", "exception", "getException", "setException", "(Ljava/lang/String;)V", "flowInfos", "", "Lcom/ss/android/ugc/bytex/common/builder/internal/BuildRecorder$TransformInfoRecord$TransformFlowInfoRecord;", "getFlowInfos", "()Ljava/util/List;", "setFlowInfos", "(Ljava/util/List;)V", "name", "getName", "startTime", "getStartTime", "setStartTime", "taskName", "getTaskName", "TransformFlowInfoRecord", "TransformEngine"})
    private static final class TransformInfoRecord {
        private final String name;
        private final String className;
        @NotNull
        private final String taskName;
        private long startTime;
        private long endTime;
        @Nullable
        private String exception;
        @NotNull
        private List<TransformFlowInfoRecord> flowInfos;

        public final String getName() {
            return this.name;
        }

        public final String getClassName() {
            return this.className;
        }

        @NotNull
        public final String getTaskName() {
            return this.taskName;
        }

        public final long getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(long l) {
            this.startTime = l;
        }

        public final long getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(long l) {
            this.endTime = l;
        }

        @Nullable
        public final String getException() {
            return this.exception;
        }

        public final void setException(@Nullable String string) {
            this.exception = string;
        }

        @NotNull
        public final List<TransformFlowInfoRecord> getFlowInfos() {
            return this.flowInfos;
        }

        public final void setFlowInfos(@NotNull List<TransformFlowInfoRecord> list) {
            Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
            this.flowInfos = list;
        }

        /*
         * WARNING - void declaration
         */
        public TransformInfoRecord(@NotNull DefaultByteXBuildListener.TransformInfo transformInfo, @NotNull Map<IPlugin, PluginStatus> pluginStatuses) {
            void $this$sortedBy$iv;
            Collection<TransformFlowInfoRecord> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkParameterIsNotNull((Object)transformInfo, (String)"transformInfo");
            Intrinsics.checkParameterIsNotNull(pluginStatuses, (String)"pluginStatuses");
            this.name = transformInfo.getTransform().getName();
            this.className = transformInfo.getTransform().getClass().getName();
            this.taskName = transformInfo.getTaskName();
            this.startTime = transformInfo.getStartTime();
            this.endTime = transformInfo.getEndTime();
            Exception exception = transformInfo.getException();
            this.exception = exception != null ? exception.getMessage() : null;
            Collection<DefaultByteXBuildListener.TransformFlowInfo> collection2 = transformInfo.getFlowInfos().values();
            Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"transformInfo.flowInfos.values");
            Iterable iterable = collection2;
            TransformInfoRecord transformInfoRecord = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DefaultByteXBuildListener.TransformFlowInfo transformFlowInfo = (DefaultByteXBuildListener.TransformFlowInfo)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void v2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                TransformFlowInfoRecord transformFlowInfoRecord = new TransformFlowInfoRecord((DefaultByteXBuildListener.TransformFlowInfo)v2, pluginStatuses);
                collection.add(transformFlowInfoRecord);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = collection;
            boolean $i$f$sortedBy = false;
            var5_6 = $this$sortedBy$iv;
            boolean bl = false;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    TransformFlowInfoRecord it = (TransformFlowInfoRecord)a;
                    boolean bl2 = false;
                    Comparable comparable = Long.valueOf(it.getStartRunningTime());
                    it = (TransformFlowInfoRecord)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Long l = it.getStartRunningTime();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                }
            };
            collection = CollectionsKt.sortedWith((Iterable)var5_6, (Comparator)comparator);
            transformInfoRecord.flowInfos = collection;
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u001a\u0010\u0019\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\f\"\u0004\b\u001b\u0010\u000eR\u001a\u0010\u001c\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\f\"\u0004\b\u001e\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/ss/android/ugc/bytex/common/builder/internal/BuildRecorder$TransformInfoRecord$TransformFlowInfoRecord;", "", "flowInfo", "Lcom/ss/android/ugc/bytex/common/builder/internal/DefaultByteXBuildListener$TransformFlowInfo;", "pluginStatuses", "", "Lcom/ss/android/ugc/bytex/common/IPlugin;", "Lcom/ss/android/ugc/bytex/common/builder/internal/PluginStatus;", "(Lcom/ss/android/ugc/bytex/common/builder/internal/DefaultByteXBuildListener$TransformFlowInfo;Ljava/util/Map;)V", "finishPrepareTime", "", "getFinishPrepareTime", "()J", "setFinishPrepareTime", "(J)V", "finishRunningTime", "getFinishRunningTime", "setFinishRunningTime", "handlers", "", "Lcom/ss/android/ugc/bytex/common/builder/internal/DefaultByteXBuildListener$MainProcessHandlerInfo;", "getHandlers", "()Ljava/util/List;", "plugins", "getPlugins", "startPrepareTime", "getStartPrepareTime", "setStartPrepareTime", "startRunningTime", "getStartRunningTime", "setStartRunningTime", "TransformEngine"})
        public static final class TransformFlowInfoRecord {
            @NotNull
            private final List<DefaultByteXBuildListener.MainProcessHandlerInfo> handlers;
            @NotNull
            private final List<PluginStatus> plugins;
            private long startPrepareTime;
            private long finishPrepareTime;
            private long startRunningTime;
            private long finishRunningTime;

            @NotNull
            public final List<DefaultByteXBuildListener.MainProcessHandlerInfo> getHandlers() {
                return this.handlers;
            }

            @NotNull
            public final List<PluginStatus> getPlugins() {
                return this.plugins;
            }

            public final long getStartPrepareTime() {
                return this.startPrepareTime;
            }

            public final void setStartPrepareTime(long l) {
                this.startPrepareTime = l;
            }

            public final long getFinishPrepareTime() {
                return this.finishPrepareTime;
            }

            public final void setFinishPrepareTime(long l) {
                this.finishPrepareTime = l;
            }

            public final long getStartRunningTime() {
                return this.startRunningTime;
            }

            public final void setStartRunningTime(long l) {
                this.startRunningTime = l;
            }

            public final long getFinishRunningTime() {
                return this.finishRunningTime;
            }

            public final void setFinishRunningTime(long l) {
                this.finishRunningTime = l;
            }

            /*
             * WARNING - void declaration
             */
            public TransformFlowInfoRecord(@NotNull DefaultByteXBuildListener.TransformFlowInfo flowInfo, @NotNull Map<IPlugin, PluginStatus> pluginStatuses) {
                DefaultByteXBuildListener.MainProcessHandlerInfo mainProcessHandlerInfo;
                Collection<Object> collection;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Intrinsics.checkParameterIsNotNull((Object)flowInfo, (String)"flowInfo");
                Intrinsics.checkParameterIsNotNull(pluginStatuses, (String)"pluginStatuses");
                Map map = flowInfo.getHandlers();
                TransformFlowInfoRecord transformFlowInfoRecord = this;
                boolean $i$f$map = false;
                void var5_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv;
                boolean bl = false;
                Object object = iterator.entrySet().iterator();
                while (object.hasNext()) {
                    void it;
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = object.next();
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    mainProcessHandlerInfo = (DefaultByteXBuildListener.MainProcessHandlerInfo)it.getValue();
                    collection.add(mainProcessHandlerInfo);
                }
                collection = (List)destination$iv$iv;
                transformFlowInfoRecord.handlers = collection;
                List<IPlugin> list = flowInfo.getPlugins();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"flowInfo.plugins");
                $this$map$iv = list;
                transformFlowInfoRecord = this;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    object = (IPlugin)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    if (pluginStatuses.get(it) == null) {
                        Intrinsics.throwNpe();
                    }
                    collection.add(mainProcessHandlerInfo);
                }
                collection = (List)destination$iv$iv;
                transformFlowInfoRecord.plugins = collection;
                this.startPrepareTime = flowInfo.getStartPrepareTime();
                this.finishPrepareTime = flowInfo.getFinishPrepareTime();
                this.startRunningTime = flowInfo.getStartRunningTime();
                this.finishRunningTime = flowInfo.getFinishRunningTime();
            }
        }
    }
}

