/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.flow;

import com.ss.android.ugc.bytex.common.flow.TransformFlow;
import com.ss.android.ugc.bytex.transformer.TransformContext;
import com.ss.android.ugc.bytex.transformer.TransformEngine;
import com.ss.android.ugc.bytex.transformer.processor.FileProcessor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public abstract class AbsTransformFlow
implements TransformFlow {
    private TransformFlow preTransformFlow = null;
    private TransformFlow nextTransformFlow = null;
    protected final TransformEngine transformEngine;
    protected final TransformContext context;

    public AbsTransformFlow(TransformEngine transformEngine) {
        this.transformEngine = transformEngine;
        this.context = transformEngine.getContext();
    }

    @Deprecated
    protected void beginRun() {
        this.markRunningState(TransformContext.State.INITIALIZING);
    }

    @Deprecated
    protected void running() {
        this.markRunningState(TransformContext.State.TRAVERSING);
    }

    @Deprecated
    public void endRun() {
        this.markRunningState(TransformContext.State.STATELESS);
    }

    protected void markRunningState(TransformContext.State state) {
        this.transformEngine.markRunningState(state);
    }

    @Override
    public File getGraphCache() {
        return new File(this.context.byteXBuildDir(), "graphCache-" + this.name() + ".json");
    }

    protected AbsTransformFlow traverse(FileProcessor ... processors) throws IOException, InterruptedException {
        this.traverseArtifactOnly(processors);
        this.traverseAndroidJarOnly(processors);
        return this;
    }

    protected AbsTransformFlow traverseArtifactOnly(FileProcessor ... processors) throws IOException, InterruptedException {
        this.transformEngine.traverseOnly(processors);
        return this;
    }

    protected AbsTransformFlow traverseAndroidJarOnly(FileProcessor ... processors) throws IOException, InterruptedException {
        this.transformEngine.traverseAndroidJar(this.androidJar(), processors);
        return this;
    }

    protected File androidJar() throws FileNotFoundException {
        return this.context.androidJar();
    }

    protected AbsTransformFlow transform(FileProcessor ... processors) throws IOException, InterruptedException {
        this.markRunningState(TransformContext.State.BEFORETRANSFORM);
        this.beforeTransform(this.transformEngine);
        this.markRunningState(TransformContext.State.TRANSFORMING);
        this.transform(this.transformEngine, this.nextTransformFlow == null, processors);
        this.markRunningState(TransformContext.State.AFTERTRANSFORM);
        this.afterTransform(this.transformEngine);
        return this;
    }

    protected abstract AbsTransformFlow beforeTransform(TransformEngine var1) throws IOException;

    protected AbsTransformFlow transform(TransformEngine transformEngine, boolean isLast, FileProcessor ... processors) throws IOException {
        transformEngine.transform(isLast, processors);
        return this;
    }

    protected abstract AbsTransformFlow afterTransform(TransformEngine var1) throws IOException;

    @Override
    public void setPreTransformFlow(TransformFlow transformFlow) {
        this.preTransformFlow = transformFlow;
    }

    @Override
    public TransformFlow getPreTransformFlow() {
        return this.preTransformFlow;
    }

    @Override
    public void setNextTransformFlow(TransformFlow transformFlow) {
        this.nextTransformFlow = transformFlow;
    }

    @Override
    public TransformFlow getNextTransformFlow() {
        return this.nextTransformFlow;
    }

    @Override
    @NotNull
    public Iterator<TransformFlow> iterator() {
        return new Iterator<TransformFlow>(){
            TransformFlow current;
            {
                this.current = AbsTransformFlow.this;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public TransformFlow next() {
                TransformFlow r = this.current;
                if (r == null) {
                    throw new IllegalStateException("There is no next TransformFlow");
                }
                this.current = this.current.getNextTransformFlow();
                return r;
            }
        };
    }
}

