/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.flow;

import com.ss.android.ugc.bytex.common.builder.internal.GlobalByteXBuildListener;
import com.ss.android.ugc.bytex.common.flow.TransformFlow;
import com.ss.android.ugc.bytex.common.flow.TransformFlowListener;
import com.ss.android.ugc.bytex.common.flow.main.MainProcessHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TransformFlowListenerManager
implements TransformFlowListener {
    private Set<TransformFlowListener> listeners = new HashSet<TransformFlowListener>();

    public TransformFlowListenerManager() {
        this.listeners.add(GlobalByteXBuildListener.INSTANCE);
    }

    @Override
    public void startPrepare(@Nonnull TransformFlow transformFlow) {
        for (TransformFlowListener listener : this.getListeners()) {
            listener.startPrepare(transformFlow);
        }
    }

    @Override
    public void finishPrepare(@Nonnull TransformFlow transformFlow, @Nullable Exception exception) {
        for (TransformFlowListener listener : this.getListeners()) {
            listener.finishPrepare(transformFlow, exception);
        }
    }

    @Override
    public void startRunning(@Nonnull TransformFlow transformFlow, boolean isIncremental) {
        for (TransformFlowListener listener : this.getListeners()) {
            listener.startRunning(transformFlow, isIncremental);
        }
    }

    @Override
    public void finishRunning(@Nonnull TransformFlow transformFlow, @Nullable Exception exception) {
        for (TransformFlowListener listener : this.getListeners()) {
            listener.finishRunning(transformFlow, exception);
        }
    }

    @Override
    public void onAppendMainProcessHandler(@Nonnull TransformFlow transformFlow, MainProcessHandler handler) {
        for (TransformFlowListener listener : this.getListeners()) {
            listener.onAppendMainProcessHandler(transformFlow, handler);
        }
    }

    private synchronized List<TransformFlowListener> getListeners() {
        return new ArrayList<TransformFlowListener>(this.listeners);
    }

    public synchronized void registerTransformFlowListener(TransformFlowListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void unregisterTransformFlowListener(TransformFlowListener listener) {
        this.listeners.remove(listener);
    }
}

