/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.graph;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ss.android.ugc.bytex.common.graph.ClassEntity;
import com.ss.android.ugc.bytex.common.graph.ClassNode;
import com.ss.android.ugc.bytex.common.graph.Node;
import com.ss.android.ugc.bytex.common.graph.cache.GraphTypeAdapterFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class InterfaceNode
extends Node {
    public List<InterfaceNode> children = Collections.emptyList();
    public List<ClassNode> implementedClasses = Collections.emptyList();

    public InterfaceNode(String className) {
        super(new ClassEntity(className, 512), null, Collections.emptyList());
    }

    @Override
    public void read(JsonReader jsonReader, Gson gson2) throws IOException {
        if (this.getClass() != InterfaceNode.class) {
            throw new IllegalStateException("Jsonable Not Supported");
        }
        jsonReader.beginObject();
        block19: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "parent": 
                case "p": {
                    this.parent = (ClassNode)gson2.getAdapter(ClassNode.class).read(jsonReader);
                    continue block19;
                }
                case "entity": 
                case "e": {
                    this.entity = (ClassEntity)gson2.getAdapter(ClassEntity.class).read(jsonReader);
                    continue block19;
                }
                case "interfaces": 
                case "i": {
                    this.interfaces = GraphTypeAdapterFactory.readList(jsonReader, gson2, InterfaceNode.class);
                    continue block19;
                }
                case "children": 
                case "c": {
                    this.children = GraphTypeAdapterFactory.readList(jsonReader, gson2, InterfaceNode.class);
                    continue block19;
                }
                case "implementedClasses": 
                case "ic": {
                    this.implementedClasses = GraphTypeAdapterFactory.readList(jsonReader, gson2, ClassNode.class);
                    continue block19;
                }
            }
            throw new RuntimeException("unsupport json name:" + name);
        }
        jsonReader.endObject();
    }

    @Override
    public void write(JsonWriter jsonWriter, Gson gson2) throws IOException {
        if (this.getClass() != InterfaceNode.class) {
            throw new IllegalStateException("Jsonable Not Supported");
        }
        jsonWriter.beginObject();
        if (this.parent != null) {
            jsonWriter.name("p");
            gson2.getAdapter(ClassNode.class).write(jsonWriter, (Object)this.parent);
        }
        if (this.entity != null) {
            jsonWriter.name("e");
            gson2.getAdapter(ClassEntity.class).write(jsonWriter, (Object)this.entity);
        }
        if (this.interfaces != null && !this.interfaces.isEmpty()) {
            jsonWriter.name("i");
            GraphTypeAdapterFactory.writeList(jsonWriter, gson2, this.interfaces);
        }
        if (this.children != null && !this.children.isEmpty()) {
            jsonWriter.name("c");
            GraphTypeAdapterFactory.writeList(jsonWriter, gson2, this.children);
        }
        if (this.implementedClasses != null && !this.implementedClasses.isEmpty()) {
            jsonWriter.name("ic");
            GraphTypeAdapterFactory.writeList(jsonWriter, gson2, this.implementedClasses);
        }
        jsonWriter.endObject();
    }
}

