/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.common.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class Bucket<T> {
    private T[] data;
    private int size;
    private IndexFunction indexFunction;

    public Bucket(T[] data, IndexFunction function) {
        this.data = data;
        this.size = data.length;
        this.indexFunction = function;
    }

    public T get(String key) {
        return this.data[this.indexFunction.getIndex(key)];
    }

    public void put(String key, T value) {
        this.data[this.indexFunction.getIndex((String)key)] = value;
    }

    public void set(int index, T value) {
        this.data[index] = value;
    }

    public T computIfAbsent(String key, Function<String, ? extends T> func) {
        int index = this.indexFunction.getIndex(key);
        T elem = this.data[index];
        if (elem == null) {
            this.data[index] = elem = func.apply(key);
        }
        return elem;
    }

    public List<T> asList() {
        ArrayList list = new ArrayList();
        Collections.addAll(list, this.data);
        return list;
    }

    public int size() {
        return this.size;
    }

    public void release() {
        this.data = null;
    }

    public static interface IndexFunction {
        public int getIndex(String var1);
    }
}

