/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.transformer.cache;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.ss.android.ugc.bytex.transformer.TransformContext;
import com.ss.android.ugc.bytex.transformer.cache.FileData;
import com.ss.android.ugc.bytex.transformer.concurrent.Schedulers;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.functions.Consumer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public abstract class FileCache
implements Serializable {
    protected QualifiedContent content;
    protected TransformContext context;
    protected List<FileData> files;
    protected boolean hasRead = false;
    private boolean hasWritten = false;

    public FileCache(QualifiedContent content, TransformContext context2) {
        this.content = content;
        this.context = context2;
    }

    public void forEach(Consumer<FileData> visitor) {
        this.parallelForEach(false, visitor);
    }

    public void parallelForEach(boolean parallel, Consumer<FileData> visitor) {
        this.stream(parallel).subscribe(visitor);
    }

    public final Observable<FileData> stream() {
        return this.stream(false);
    }

    public final Observable<FileData> stream(boolean tryParallel) {
        return Observable.create(emitter -> {
            if (this.files == null) {
                FileCache fileCache = this;
                synchronized (fileCache) {
                    if (this.files == null) {
                        this.files = this.resolve((ObservableEmitter<FileData>)emitter);
                        this.hasRead = true;
                    } else if (tryParallel) {
                        Schedulers.IO().submitAndAwait(this.files, arg_0 -> ((ObservableEmitter)emitter).onNext(arg_0));
                    } else {
                        this.files.forEach(arg_0 -> ((ObservableEmitter)emitter).onNext(arg_0));
                    }
                }
            } else if (tryParallel) {
                Schedulers.IO().submitAndAwait(this.files, arg_0 -> ((ObservableEmitter)emitter).onNext(arg_0));
            } else {
                this.files.forEach(arg_0 -> ((ObservableEmitter)emitter).onNext(arg_0));
            }
            emitter.onComplete();
        });
    }

    public final void transformOutput() throws IOException {
        this.transformOutput(null);
    }

    public abstract void transformOutput(Consumer<FileData> var1) throws IOException;

    protected synchronized void output() {
        if (this.hasWritten && !this.context.getTransformOptions().isAllowRewrite()) {
            throw new RuntimeException("rewrite");
        }
        this.hasWritten = true;
    }

    protected abstract List<FileData> resolve(ObservableEmitter<FileData> var1) throws IOException;

    public abstract void skip() throws IOException;

    public QualifiedContent getContent() {
        return this.content;
    }

    public List<FileData> getChangedFiles() {
        if (this.context.isIncremental()) {
            return (List)this.stream().filter(fileData -> fileData.getStatus() != Status.NOTCHANGED).toList().blockingGet();
        }
        return Collections.emptyList();
    }

    public File getFile() {
        if (this.content != null) {
            return this.content.getFile();
        }
        return null;
    }

    public boolean containsFileData(String relativePath) {
        return this.stream().filter(fileData -> fileData.getStatus() != Status.REMOVED && fileData.getRelativePath().equals(relativePath)).firstElement().blockingGet() != null;
    }

    public boolean isHasWritten() {
        return this.hasWritten;
    }
}

