/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.transformer.cache;

import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.utils.FileUtils;
import com.google.common.io.ByteStreams;
import com.ss.android.ugc.bytex.transformer.TransformContext;
import com.ss.android.ugc.bytex.transformer.TransformOutputs;
import com.ss.android.ugc.bytex.transformer.cache.FileCache;
import com.ss.android.ugc.bytex.transformer.cache.FileData;
import io.reactivex.ObservableEmitter;
import io.reactivex.functions.Consumer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class JarCache
extends FileCache {
    private final File jar;
    private final Status status;
    private final File outputFile;
    private boolean useFixedTimestamp = false;

    public JarCache(QualifiedContent content, TransformContext context2) {
        this(content, context2, false);
    }

    public JarCache(QualifiedContent content, TransformContext context2, boolean useFixedTimestamp) {
        super(content, context2);
        this.jar = content.getFile();
        this.status = ((JarInput)content).getStatus();
        this.useFixedTimestamp = useFixedTimestamp;
        try {
            this.outputFile = context2.getOutputFile(content, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JarCache(File jar, TransformContext context2) {
        this(jar, Status.ADDED, context2);
    }

    public JarCache(File jar, Status status, TransformContext context2) {
        super(null, context2);
        this.jar = jar;
        this.status = status;
        this.outputFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void transformOutput(Consumer<FileData> visitor) throws IOException {
        boolean needOutput;
        this.output();
        List<FileData> dataList = Collections.synchronizedList(new LinkedList());
        this.forEach((Consumer<FileData>)((Consumer)item -> {
            if (visitor != null) {
                visitor.accept(item);
            }
            dataList.add(item);
        }));
        String outputRelativePath = this.context.getTransformOutputs().relativeToProject(this.outputFile);
        TransformOutputs.Entry outputs = this.context.getTransformOutputs().getLastTransformOutputs().get(outputRelativePath);
        boolean isHookJar = this.outputFile.getAbsolutePath().equals(this.getFile().getAbsolutePath());
        boolean bl = needOutput = !this.context.getInvocation().isIncremental() || isHookJar;
        if (!needOutput) {
            needOutput = dataList.stream().flatMap(fileData -> fileData.allFiles().stream()).anyMatch(fileData -> fileData.getStatus() != Status.NOTCHANGED);
        }
        if (needOutput || dataList.isEmpty()) {
            if (dataList.isEmpty()) {
                FileUtils.deleteIfExists((File)this.outputFile);
            }
            dataList.sort((t0, t1) -> t0.getRelativePath().compareTo(t1.getRelativePath()));
            TransformOutputs.Entry mapToEntry = new TransformOutputs.Entry(this.context.getTransformOutputs().relativeToProject(this.getFile()), outputRelativePath, this.outputFile.exists() ? TransformOutputs.Entry.Companion.hash(this.outputFile) : Long.MAX_VALUE, dataList.stream().map(fileData -> TransformOutputs.Entry.Companion.outputEntry((FileData)fileData, outputRelativePath)).sorted().collect(Collectors.toList()));
            if (!(dataList.size() <= 0 || this.outputFile.exists() && outputs != null && outputs.getIdentify() == mapToEntry.getIdentify())) {
                AtomicBoolean hasOutput = new AtomicBoolean(false);
                File copyFile = Files.createTempFile(String.valueOf(this.outputFile.getAbsolutePath().hashCode()), "", new FileAttribute[0]).toFile();
                ZipFile jarFile = null;
                try {
                    if (!isHookJar && this.outputFile.exists() && dataList.stream().flatMap(fileData -> fileData.allFiles().stream()).anyMatch(fileData -> fileData.getStatus() == Status.NOTCHANGED)) {
                        FileUtils.copyFile((File)this.outputFile, (File)copyFile);
                        jarFile = new JarFile(copyFile);
                    }
                    Object reason = "Unknown";
                    if (isHookJar) {
                        reason = "Hook Jar";
                    } else if (!this.outputFile.exists()) {
                        reason = "outputFile not exists(Most likely it is full compilation)";
                    } else if (outputs == null) {
                        reason = "lost last outputs";
                    } else if (outputs.getIdentify() != mapToEntry.getIdentify()) {
                        reason = "content changed:" + outputs.getIdentify() + "->" + mapToEntry.getIdentify();
                    }
                    System.out.println("ByteX outputJar:" + this.getFile().getAbsolutePath() + "->" + this.outputFile.getAbsolutePath() + ":reason:" + (String)reason);
                    try (JarOutputStream jos = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(this.outputFile)));){
                        for (FileData item2 : dataList) {
                            for (FileData file : item2.allFiles()) {
                                byte[] bytes;
                                switch (file.getStatus()) {
                                    case ADDED: 
                                    case CHANGED: {
                                        bytes = file.getBytes();
                                        break;
                                    }
                                    case NOTCHANGED: {
                                        if (jarFile == null) {
                                            throw new IllegalStateException("outputFile not exists:" + this.outputFile.getAbsolutePath());
                                        }
                                        bytes = ByteStreams.toByteArray((InputStream)((JarFile)jarFile).getInputStream(((JarFile)jarFile).getEntry(file.getRelativePath())));
                                        break;
                                    }
                                    case REMOVED: {
                                        bytes = null;
                                        break;
                                    }
                                    default: {
                                        throw new IllegalStateException(file.getStatus().toString());
                                    }
                                }
                                if (bytes == null) continue;
                                ZipEntry entry = new ZipEntry(file.getRelativePath());
                                if (this.useFixedTimestamp) {
                                    entry.setTime(0L);
                                    entry.setCreationTime(FileTime.fromMillis(0L));
                                    entry.setLastAccessTime(FileTime.fromMillis(0L));
                                    entry.setLastModifiedTime(FileTime.fromMillis(0L));
                                }
                                jos.putNextEntry(entry);
                                jos.write(bytes);
                                hasOutput.set(true);
                            }
                        }
                    }
                }
                finally {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                    FileUtils.delete((File)copyFile);
                }
                if (!hasOutput.get()) {
                    FileUtils.deleteIfExists((File)this.outputFile);
                }
                mapToEntry = new TransformOutputs.Entry(mapToEntry.getInput(), mapToEntry.getPath(), this.outputFile.exists() ? TransformOutputs.Entry.Companion.hash(this.outputFile) : Long.MAX_VALUE, mapToEntry.getExtras());
            }
            outputs = mapToEntry;
        }
        this.context.getTransformOutputs().getTransformOutputs().put(outputRelativePath, outputs);
    }

    @Override
    protected List<FileData> resolve(ObservableEmitter<FileData> emitter) throws IOException {
        if (this.context.getInvocation().isIncremental()) {
            Set<String> items = this.context.getTransformInputs().getLastTransformInputs().get(this.getFile().getAbsolutePath());
            if (this.status == Status.REMOVED) {
                if (this.outputFile != null) {
                    FileUtils.deleteIfExists((File)this.outputFile);
                }
                if (items == null) {
                    return Collections.emptyList();
                }
                return items.stream().map(s -> {
                    FileData fileData = new FileData((byte[])null, (String)s, Status.REMOVED);
                    if (emitter != null) {
                        emitter.onNext((Object)fileData);
                    }
                    return fileData;
                }).collect(Collectors.toList());
            }
            ConcurrentHashMap<String, FileData> dataMap = new ConcurrentHashMap<String, FileData>();
            AtomicBoolean once = new AtomicBoolean(false);
            FileData.LoadFunction loadFunction = fileData -> {
                Map map = dataMap;
                synchronized (map) {
                    if (once.compareAndSet(false, true)) {
                        System.out.println("ByteX LoadJar:" + this.getFile().getAbsolutePath());
                        try (ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.getFile())));){
                            ZipEntry zipEntry;
                            while ((zipEntry = zin.getNextEntry()) != null) {
                                FileData item;
                                if (zipEntry.isDirectory() || (item = (FileData)dataMap.get(zipEntry.getName())).contentLoaded()) continue;
                                item.setBytes(ByteStreams.toByteArray((InputStream)zin), item.getStatus());
                            }
                        }
                        for (FileData value : dataMap.values()) {
                            if (value.contentLoaded()) continue;
                            throw new RuntimeException(value.getRelativePath() + "unloaded");
                        }
                    }
                }
                return fileData.getBytes();
            };
            if (this.status == Status.NOTCHANGED && items != null) {
                for (String item : items) {
                    dataMap.put(item, new FileData(loadFunction, item, Status.NOTCHANGED));
                }
            } else {
                try (ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.getFile())));){
                    ZipEntry zipEntry;
                    while ((zipEntry = zin.getNextEntry()) != null) {
                        if (zipEntry.isDirectory()) continue;
                        if (this.status == Status.NOTCHANGED) {
                            dataMap.put(zipEntry.getName(), new FileData(loadFunction, zipEntry.getName(), Status.NOTCHANGED));
                            continue;
                        }
                        Status thisStatus = this.status;
                        if (this.status == Status.CHANGED && items != null && !items.contains(zipEntry.getName())) {
                            thisStatus = Status.ADDED;
                        }
                        dataMap.put(zipEntry.getName(), new FileData(ByteStreams.toByteArray((InputStream)zin), zipEntry.getName(), thisStatus));
                    }
                }
                if (this.status == Status.CHANGED && items != null) {
                    for (String item : items) {
                        if (dataMap.containsKey(item)) continue;
                        dataMap.put(item, new FileData((byte[])null, item, Status.REMOVED));
                    }
                }
            }
            if (emitter != null) {
                dataMap.values().forEach(arg_0 -> emitter.onNext(arg_0));
            }
            return new ArrayList<FileData>(dataMap.values());
        }
        File file = this.getFile();
        if (!file.exists()) {
            return Collections.emptyList();
        }
        ArrayList<FileData> dataList = new ArrayList<FileData>();
        try (ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.getFile())));){
            ZipEntry zipEntry;
            while ((zipEntry = zin.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                FileData data = new FileData(ByteStreams.toByteArray((InputStream)zin), zipEntry.getName(), Status.ADDED);
                if (emitter != null) {
                    emitter.onNext((Object)data);
                }
                dataList.add(data);
            }
        }
        return dataList;
    }

    @Override
    public synchronized void skip() throws IOException {
        this.output();
        FileUtils.copyFile((File)this.getFile(), (File)this.outputFile);
    }

    @Override
    public File getFile() {
        return this.jar;
    }
}

