/*
 * Decompiled with CFR 0.152.
 */
package com.ss.android.ugc.bytex.transformer.io;

import com.ss.android.ugc.bytex.transformer.TransformContext;
import com.ss.android.ugc.bytex.transformer.cache.FileCache;
import com.ss.android.ugc.bytex.transformer.cache.JarCache;
import com.ss.android.ugc.bytex.transformer.io.ClassFinder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class ClassNodeLoader
implements ClassFinder {
    private final ClassLoader cl;

    public ClassNodeLoader(TransformContext context2) {
        URL[] urls = (URL[])Stream.concat(Stream.concat(context2.getAllJars().stream(), context2.getAllDirs().stream()), this.getAndroidJar(context2).stream()).map(FileCache::getFile).map(File::toURI).map(u -> {
            try {
                return u.toURL();
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }).toArray(URL[]::new);
        this.cl = URLClassLoader.newInstance(urls, null);
    }

    @NotNull
    private Collection<JarCache> getAndroidJar(TransformContext context2) {
        try {
            return Collections.singleton(new JarCache(context2.androidJar(), context2));
        }
        catch (FileNotFoundException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public ClassNode find(String className, int parsingOption) {
        try {
            URL url = this.cl.getResource(className + ".class");
            if (url == null) {
                return null;
            }
            URLConnection urlConnection = url.openConnection();
            urlConnection.setUseCaches(false);
            ClassReader cr = new ClassReader(urlConnection.getInputStream());
            urlConnection.getInputStream().close();
            ClassNode cn = new ClassNode();
            cr.accept((ClassVisitor)cn, parsingOption);
            return cn;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public ClassNode find(String className) {
        return this.find(className, 2);
    }

    @Override
    public Class<?> loadClass(String className) {
        try {
            return this.cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

