/*
 * Decompiled with CFR 0.152.
 */
package zsu.kni.ksp.native;

import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.Dependencies;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSFile;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.squareup.kotlinpoet.ClassName;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import zsu.kni.ksp.KniContext;
import zsu.kni.ksp.KniEnvContext;
import zsu.kni.ksp.UtilsKt;
import zsu.kni.ksp.native.KniNativeSP;
import zsu.kni.ksp.native.NativeApiGen;
import zsu.kni.ksp.native.NativeImplGen;
import zsu.kni.ksp.template.NativeEnvStoreImpl;
import zsu.kni.ksp.template.NativeProtoImpl;
import zsu.kni.ksp.template.Template;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lzsu/kni/ksp/native/KniNativeSP;", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "env", "Lzsu/kni/ksp/KniEnvContext;", "(Lzsu/kni/ksp/KniEnvContext;)V", "nativeStableGeneratedDependencies", "Lcom/google/devtools/ksp/processing/Dependencies;", "process", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "createNativeTemplateFile", "", "Lzsu/kni/ksp/KniContext;", "template", "Lzsu/kni/ksp/template/Template;", "generatedClassName", "Lcom/squareup/kotlinpoet/ClassName;", "ksp"})
public final class KniNativeSP
implements SymbolProcessor {
    @NotNull
    private final KniEnvContext env;
    @NotNull
    private final Dependencies nativeStableGeneratedDependencies;

    public KniNativeSP(@NotNull KniEnvContext env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        this.env = env;
        this.nativeStableGeneratedDependencies = new Dependencies(false, new KSFile[0]);
    }

    @NotNull
    public List<KSAnnotated> process(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        KniContext context = new KniContext(this.env, resolver);
        Sequence allJniImplFunc2 = SequencesKt.map((Sequence)Resolver.getSymbolsWithAnnotation$default((Resolver)resolver, (String)UtilsKt.getJniImplFqn(), (boolean)false, (int)2, null), (Function1)process.allJniImplFunc.1.INSTANCE);
        boolean hasGeneratedImpl = new NativeImplGen(context).generate((Sequence<KSFunctionDeclaration>)allJniImplFunc2);
        Sequence allJniApiFunc2 = SequencesKt.map((Sequence)Resolver.getSymbolsWithAnnotation$default((Resolver)resolver, (String)UtilsKt.getJniApiFqn(), (boolean)false, (int)2, null), (Function1)process.allJniApiFunc.1.INSTANCE);
        boolean hasGeneratedApi = new NativeApiGen(context).generate((Sequence<KSFunctionDeclaration>)allJniApiFunc2);
        if (hasGeneratedImpl || hasGeneratedApi) {
            this.createNativeTemplateFile(context, NativeEnvStoreImpl.INSTANCE, this.env.getJniEnvStoreClassName());
            this.createNativeTemplateFile(context, NativeProtoImpl.INSTANCE, this.env.getProtoClassName());
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createNativeTemplateFile(KniContext $this$createNativeTemplateFile, Template template, ClassName generatedClassName) {
        OutputStream protoFile;
        if ($this$createNativeTemplateFile.optClass(generatedClassName) != null) {
            return;
        }
        String simpleClassName = generatedClassName.getSimpleName();
        Closeable closeable = protoFile = CodeGenerator.createNewFile$default((CodeGenerator)this.env.getCodeGenerator(), (Dependencies)this.nativeStableGeneratedDependencies, (String)this.env.getGeneratedPackage(), (String)simpleClassName, null, (int)8, null);
        Object object = Charsets.UTF_8;
        Writer writer = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
        object = null;
        try {
            BufferedWriter it = (BufferedWriter)closeable;
            boolean bl = false;
            String implText = template.create(generatedClassName.getPackageName(), simpleClassName, this.env.getJniPackage());
            it.write(implText);
            writer = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }
}

