/*
 * Decompiled with CFR 0.152.
 */
package zsu.kni.ksp.native;

import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSType;
import com.google.devtools.ksp.symbol.KSTypeReference;
import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.ksp.KsClassDeclarationsKt;
import com.squareup.kotlinpoet.ksp.KsTypesKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import zsu.kni.internal.JniTypeName;
import zsu.kni.internal.JvmBytecodeType;
import zsu.kni.ksp.JniFuncName;
import zsu.kni.ksp.JniUtilsKt;
import zsu.kni.ksp.KniContext;
import zsu.kni.ksp.PoetUtilKt;
import zsu.kni.ksp.SerializerNamesKt;
import zsu.kni.ksp.UtilsKt;
import zsu.kni.ksp.native.ImplParameters;
import zsu.kni.ksp.native.NativeFunctionGenByPackage;
import zsu.kni.ksp.native.NativeImplGen;
import zsu.kni.ksp.native.NativeImplGenKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u001c\u0010\u0010\u001a\u00020\u0011*\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u001c\u0010\u0012\u001a\u00020\u0011*\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u001c\u0010\u0013\u001a\u00020\u0011*\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u001c\u0010\u0014\u001a\u00020\u0011*\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J(\u0010\u0015\u001a\u00020\u0011*\u00020\u000e2\u001a\u0010\u0016\u001a\u0016\u0012\b\u0012\u00060\u0018j\u0002`\u0019\u0012\u0004\u0012\u00020\u001a0\u0017j\u0002`\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lzsu/kni/ksp/native/NativeImplGen;", "Lzsu/kni/ksp/native/NativeFunctionGenByPackage;", "Lzsu/kni/ksp/native/ImplParameters;", "context", "Lzsu/kni/ksp/KniContext;", "(Lzsu/kni/ksp/KniContext;)V", "generatedFileName", "", "getGeneratedFileName", "()Ljava/lang/String;", "parametersFromFunction", "function", "Lcom/google/devtools/ksp/symbol/KSFunctionDeclaration;", "prepareBuilder", "Lcom/squareup/kotlinpoet/FunSpec$Builder;", "parameters", "buildAllParams", "", "buildMethodCall", "buildNativeBridge", "buildReturn", "singleParam", "parameter", "Lkotlin/Pair;", "Lcom/squareup/kotlinpoet/TypeName;", "Lzsu/kni/ksp/native/OriginClassType;", "Lcom/squareup/kotlinpoet/ParameterSpec;", "Lzsu/kni/ksp/native/ImplParamRecord;", "ksp"})
@SourceDebugExtension(value={"SMAP\nNativeImplGen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeImplGen.kt\nzsu/kni/ksp/native/NativeImplGen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1855#2,2:161\n*S KotlinDebug\n*F\n+ 1 NativeImplGen.kt\nzsu/kni/ksp/native/NativeImplGen\n*L\n46#1:161,2\n*E\n"})
public final class NativeImplGen
extends NativeFunctionGenByPackage<ImplParameters> {
    @NotNull
    private final KniContext context;
    @NotNull
    private final String generatedFileName;

    public NativeImplGen(@NotNull KniContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.context = context;
        this.generatedFileName = "_kni_impl";
    }

    @Override
    @NotNull
    public String getGeneratedFileName() {
        return this.generatedFileName;
    }

    @Override
    @NotNull
    public FunSpec.Builder prepareBuilder(@NotNull KSFunctionDeclaration function, @NotNull ImplParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        JniFuncName jniName = JniUtilsKt.getJniName(function, this.context);
        Object[] objectArray = new Object[]{jniName.getFullName()};
        AnnotationSpec cNameSpec = AnnotationSpec.Companion.builder(UtilsKt.getCNameClassName()).addMember("externName = %S", objectArray).build();
        return FunSpec.Companion.builder(jniName.getOwnerName() + "_" + jniName.getMethodName()).addParameters((Iterable)parameters.collectAllSpec()).addAnnotation(cNameSpec);
    }

    @Override
    public void buildNativeBridge(@NotNull FunSpec.Builder $this$buildNativeBridge, @NotNull KSFunctionDeclaration function, @NotNull ImplParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)$this$buildNativeBridge, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Object[] objectArray = new Object[]{this.getEnv().getProtoClassName()};
        UtilsKt.addVal($this$buildNativeBridge, "_proto", "%T(" + parameters.getJEnvPart().getName() + ", this)", objectArray);
        objectArray = new Object[]{this.getNativeNames().getNativeBridge()};
        UtilsKt.addVal($this$buildNativeBridge, "_bridge", "%T(_proto)", objectArray);
    }

    @Override
    public void buildAllParams(@NotNull FunSpec.Builder $this$buildAllParams, @NotNull KSFunctionDeclaration function, @NotNull ImplParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)$this$buildAllParams, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        if (!parameters.isStaticCall()) {
            KSDeclaration kSDeclaration = function.getParentDeclaration();
            Intrinsics.checkNotNull((Object)kSDeclaration, (String)"null cannot be cast to non-null type com.google.devtools.ksp.symbol.KSClassDeclaration");
            ClassName thisClassName = KsClassDeclarationsKt.toClassName((KSClassDeclaration)((KSClassDeclaration)kSDeclaration));
            this.singleParam($this$buildAllParams, (Pair<? extends TypeName, ParameterSpec>)TuplesKt.to((Object)thisClassName, (Object)parameters.getThisPart()));
        }
        if (parameters.getExtensionPart() != null && parameters.getExtensionClassName() != null) {
            this.singleParam($this$buildAllParams, (Pair<? extends TypeName, ParameterSpec>)TuplesKt.to((Object)parameters.getExtensionClassName(), (Object)parameters.getExtensionPart()));
        }
        Iterable $this$forEach$iv = parameters.getParams();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            this.singleParam($this$buildAllParams, (Pair<? extends TypeName, ParameterSpec>)it);
        }
    }

    @Override
    public void buildMethodCall(@NotNull FunSpec.Builder $this$buildMethodCall, @NotNull KSFunctionDeclaration function, @NotNull ImplParameters parameters) {
        boolean isStatic;
        Intrinsics.checkNotNullParameter((Object)$this$buildMethodCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Object callCode2 = CollectionsKt.joinToString$default((Iterable)parameters.getParams(), (CharSequence)", ", (CharSequence)"%M(", (CharSequence)")", (int)0, null, (Function1)buildMethodCall.callCode.1.INSTANCE, (int)24, null);
        if (parameters.getExtensionPart() != null) {
            callCode2 = "_" + parameters.getExtensionPart().getName() + "." + (String)callCode2;
        }
        if (!(isStatic = parameters.isStaticCall())) {
            $this$buildMethodCall.beginControlFlow("with(_" + parameters.getThisPart().getName() + ")", new Object[0]);
        }
        Object[] objectArray = new Object[]{PoetUtilKt.asMemberName(function)};
        UtilsKt.addVal($this$buildMethodCall, "returned", (String)callCode2, objectArray);
        if (!isStatic) {
            $this$buildMethodCall.endControlFlow();
        }
    }

    @Override
    public void buildReturn(@NotNull FunSpec.Builder $this$buildReturn, @NotNull KSFunctionDeclaration function, @NotNull ImplParameters parameters) {
        boolean needReturns;
        Intrinsics.checkNotNullParameter((Object)$this$buildReturn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        KSTypeReference kSTypeReference = function.getReturnType();
        Intrinsics.checkNotNull((Object)kSTypeReference);
        KSType returnType = kSTypeReference.resolve();
        String returnJniName = JniUtilsKt.getJniName$default(returnType, this.context, false, 2, null);
        boolean bl = needReturns = !JniTypeName.equals-impl0((String)returnJniName, (String)JniTypeName.Companion.getVOID-ADS2baY());
        if (!needReturns) {
            return;
        }
        ClassName returnTypeName = KsTypesKt.toClassName((KSType)returnType);
        String returnJniNameName = returnJniName;
        ClassName returnJniClassName = this.getNativeNames().jni-mYyfeQ4(returnJniName);
        FunSpec.Builder.returns$default((FunSpec.Builder)$this$buildReturn, (TypeName)((TypeName)returnJniClassName), null, (int)2, null);
        if (NativeImplGenKt.access$getDirectMappingJniNames$p().contains(returnJniNameName)) {
            $this$buildReturn.addStatement("return returned", new Object[0]);
            return;
        }
        if (Intrinsics.areEqual((Object)returnJniNameName, (Object)JvmBytecodeType.Z.getJniName())) {
            $this$buildReturn.addStatement("return if (returned) 1u else 0u", new Object[0]);
            return;
        }
        if (Intrinsics.areEqual((Object)returnJniNameName, (Object)JvmBytecodeType.C.getJniName())) {
            $this$buildReturn.addStatement("return returned.code.toUShort()", new Object[0]);
            return;
        }
        Object[] objectArray = new Object[]{returnTypeName, this.getEnv().getSerializerInternalName(), SerializerNamesKt.getSerializerName((TypeName)returnTypeName)};
        $this$buildReturn.addStatement("return _bridge." + this.getNativeNames().getC2j() + "<%T>(returned, %S, %S)", objectArray);
    }

    @Override
    @NotNull
    public ImplParameters parametersFromFunction(@NotNull KSFunctionDeclaration function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        return ImplParameters.Companion.from(this.context, function);
    }

    private final void singleParam(FunSpec.Builder $this$singleParam, Pair<? extends TypeName, ParameterSpec> parameter) {
        TypeName originClassName = (TypeName)parameter.component1();
        ParameterSpec parameterSpec = (ParameterSpec)parameter.component2();
        String oldName = parameterSpec.getName();
        TypeName typeName = parameterSpec.getType();
        Intrinsics.checkNotNull((Object)typeName, (String)"null cannot be cast to non-null type com.squareup.kotlinpoet.ClassName");
        ClassName paramType = (ClassName)typeName;
        String simpleTypeName = paramType.getSimpleName();
        String newName = "_" + oldName;
        if (NativeImplGenKt.access$getDirectMappingJniNames$p().contains(simpleTypeName)) {
            UtilsKt.addVal($this$singleParam, newName, oldName, new Object[0]);
            return;
        }
        if (Intrinsics.areEqual((Object)simpleTypeName, (Object)JvmBytecodeType.Z.getJniName())) {
            UtilsKt.addVal($this$singleParam, newName, oldName + ".toInt() == 1", new Object[0]);
            return;
        }
        if (Intrinsics.areEqual((Object)simpleTypeName, (Object)JvmBytecodeType.C.getJniName())) {
            UtilsKt.addVal($this$singleParam, newName, oldName + ".toInt().toChar()", new Object[0]);
            return;
        }
        if (!Intrinsics.areEqual((Object)simpleTypeName, (Object)JvmBytecodeType.L.getJniName())) {
            boolean bl = false;
            String string = "invalid type: `" + paramType + "` when process " + oldName;
            throw new IllegalArgumentException(string.toString());
        }
        Object[] objectArray = new Object[]{originClassName, this.getEnv().getSerializerInternalName(), SerializerNamesKt.getSerializerName(originClassName)};
        UtilsKt.addVal($this$singleParam, newName, "_bridge." + this.getNativeNames().getJ2c() + "<%T>(" + oldName + ", %S, %S)", objectArray);
    }
}

