/*
 * Decompiled with CFR 0.152.
 */
package zsu.kni.ksp.template;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import zsu.kni.ksp.template.Template;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0017\u00a8\u0006\b"}, d2={"Lzsu/kni/ksp/template/NativeEnvStoreImpl;", "Lzsu/kni/ksp/template/Template;", "()V", "create", "", "packageName", "simpleClassName", "jniPackageName", "ksp"})
public final class NativeEnvStoreImpl
implements Template {
    @NotNull
    public static final NativeEnvStoreImpl INSTANCE = new NativeEnvStoreImpl();

    private NativeEnvStoreImpl() {
    }

    @Override
    @Language(value="kotlin")
    @NotNull
    public String create(@NotNull String packageName, @NotNull String simpleClassName, @NotNull String jniPackageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)simpleClassName, (String)"simpleClassName");
        Intrinsics.checkNotNullParameter((Object)jniPackageName, (String)"jniPackageName");
        return "\n@file:OptIn(ExperimentalForeignApi::class, ExperimentalNativeApi::class)\npackage " + packageName + "\n\nimport kotlinx.cinterop.*\nimport " + jniPackageName + ".*\nimport zsu.kni.internal.native.NativeEnvStore\nimport kotlin.experimental.ExperimentalNativeApi\n\n@CName(externName = \"Java_zsu_kni_KniNativeThread_attach\")\nfun attach(\n    jenv: CPointer<JNIEnvVar>,\n    classRef: jclass,\n    id: jint,\n) {\n    NativeEnvStore[id] = jenv\n}\n\n@CName(externName = \"Java_zsu_kni_KniNativeThread_detach\")\nfun detach(\n    jenv: CPointer<JNIEnvVar>,\n    classRef: jclass,\n    id: jint,\n    sameJEnv: jint,\n) {\n    val isSameJEnv = sameJEnv == 0\n    if (isSameJEnv) {\n        val originJenvPtr: CPointer<JNIEnvVar> = NativeEnvStore[id]\n        val originJenvValue = originJenvPtr.pointed\n        val currentJenvValue = jenv.pointed\n        NativeEnvStore.compareEnv(originJenvValue, currentJenvValue)\n    }\n    NativeEnvStore.remove(id)\n}\n\n@CName(externName = \"Java_zsu_kni_KniNativeThread_detachAll\")\nfun detachAll(\n    jenv: CPointer<JNIEnvVar>,\n    classRef: jclass,\n) {\n    NativeEnvStore.clear()\n}\n\n        ";
    }
}

