/*
 * Decompiled with CFR 0.152.
 */
package zsu.kni.ksp.template;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import zsu.kni.ksp.template.Template;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0017\u00a8\u0006\b"}, d2={"Lzsu/kni/ksp/template/NativeProtoImpl;", "Lzsu/kni/ksp/template/Template;", "()V", "create", "", "packageName", "simpleClassName", "jniPackageName", "ksp"})
public final class NativeProtoImpl
implements Template {
    @NotNull
    public static final NativeProtoImpl INSTANCE = new NativeProtoImpl();

    private NativeProtoImpl() {
    }

    @Override
    @Language(value="kotlin")
    @NotNull
    public String create(@NotNull String packageName, @NotNull String simpleClassName, @NotNull String jniPackageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)simpleClassName, (String)"simpleClassName");
        Intrinsics.checkNotNullParameter((Object)jniPackageName, (String)"jniPackageName");
        return "\npackage " + packageName + "\n\nimport kotlinx.cinterop.*\nimport " + jniPackageName + ".*\nimport zsu.kni.internal.InternalName\nimport zsu.kni.internal.JvmBytecodeType\nimport zsu.kni.internal.JvmBytecodeType.*\nimport zsu.kni.internal.MethodDesc\nimport zsu.kni.internal.native.NativeProto\n\n@OptIn(ExperimentalForeignApi::class)\nclass " + simpleClassName + "(\n    private val envPtr: CPointer<JNIEnvVar>,\n    private val memAllocator: NativePlacement,\n) : NativeProto<jobject, jvalue, jmethodID> {\n    private val jEnv = envPtr.pointed.pointed!!\n    private val findClassPtr = jEnv.FindClass!!\n    private val findMethodPtr = jEnv.GetMethodID!!\n    private val findStaticMethodPtr = jEnv.GetStaticMethodID!!\n\n    private val callBoolean = jEnv.CallBooleanMethodA!!\n    private val callChar = jEnv.CallCharMethodA!!\n    private val callByte = jEnv.CallByteMethodA!!\n    private val callShort = jEnv.CallShortMethodA!!\n    private val callInt = jEnv.CallIntMethodA!!\n    private val callLong = jEnv.CallLongMethodA!!\n    private val callFloat = jEnv.CallFloatMethodA!!\n    private val callDouble = jEnv.CallDoubleMethodA!!\n    private val callObject = jEnv.CallObjectMethodA!!\n    private val callVoid = jEnv.CallVoidMethodA!!\n\n    private val callStaticBoolean = jEnv.CallStaticBooleanMethodA!!\n    private val callStaticChar = jEnv.CallStaticCharMethodA!!\n    private val callStaticByte = jEnv.CallStaticByteMethodA!!\n    private val callStaticShort = jEnv.CallStaticShortMethodA!!\n    private val callStaticInt = jEnv.CallStaticIntMethodA!!\n    private val callStaticLong = jEnv.CallStaticLongMethodA!!\n    private val callStaticFloat = jEnv.CallStaticFloatMethodA!!\n    private val callStaticDouble = jEnv.CallStaticDoubleMethodA!!\n    private val callStaticObject = jEnv.CallStaticObjectMethodA!!\n    private val callStaticVoid = jEnv.CallVoidMethodA!!\n\n\n    override fun call(\n        jObject: jobject,\n        methodId: jmethodID,\n        values: CArrayPointer<jvalue>,\n        returnType: JvmBytecodeType\n    ): jvalue? {\n        val nativeJValue = memAllocator.alloc<jvalue>()\n        with(nativeJValue) {\n            when (returnType) {\n                B -> b = callByte.invoke(envPtr, jObject, methodId, values)\n                C -> c = callChar.invoke(envPtr, jObject, methodId, values)\n                D -> d = callDouble.invoke(envPtr, jObject, methodId, values)\n                F -> f = callFloat.invoke(envPtr, jObject, methodId, values)\n                I -> i = callInt.invoke(envPtr, jObject, methodId, values)\n                J -> j = callLong.invoke(envPtr, jObject, methodId, values)\n                S -> s = callShort.invoke(envPtr, jObject, methodId, values)\n                Z -> z = callBoolean.invoke(envPtr, jObject, methodId, values)\n                L -> l = callObject.invoke(envPtr, jObject, methodId, values) ?: return null\n                V -> {\n                    callVoid.invoke(envPtr, jObject, methodId, values)\n                    return null\n                }\n            }\n        }\n        return nativeJValue\n    }\n\n    override fun callStatic(\n        jClass: jclass,\n        methodId: jmethodID,\n        values: CArrayPointer<jvalue>,\n        returnType: JvmBytecodeType\n    ): jvalue? {\n        val nativeJValue = memAllocator.alloc<jvalue>()\n        with(nativeJValue) {\n            when (returnType) {\n                B -> b = callStaticByte.invoke(envPtr, jClass, methodId, values)\n                C -> c = callStaticChar.invoke(envPtr, jClass, methodId, values)\n                D -> d = callStaticDouble.invoke(envPtr, jClass, methodId, values)\n                F -> f = callStaticFloat.invoke(envPtr, jClass, methodId, values)\n                I -> i = callStaticInt.invoke(envPtr, jClass, methodId, values)\n                J -> j = callStaticLong.invoke(envPtr, jClass, methodId, values)\n                S -> s = callStaticShort.invoke(envPtr, jClass, methodId, values)\n                Z -> z = callStaticBoolean.invoke(envPtr, jClass, methodId, values)\n                L -> l = callStaticObject.invoke(envPtr, jClass, methodId, values) ?: return null\n                V -> {\n                    callStaticVoid.invoke(envPtr, jClass, methodId, values)\n                    return null\n                }\n            }\n        }\n        return nativeJValue\n    }\n\n    override fun getJClass(clazzName: InternalName): jobject = memScoped {\n        findClassPtr(envPtr, clazzName.cstr.ptr)!!\n    }\n\n    private val objClassCallPtr = jEnv.GetObjectClass!!\n    override fun getObjClass(o: jobject): jobject {\n        return objClassCallPtr.invoke(envPtr, o)!!\n    }\n\n    override val jvalue.obtainO: jobject\n        get() = l!!\n\n    override val jobject.obtainV: jvalue\n        get() = memAllocator.alloc<jvalue> { l = this@obtainV }\n\n    override val Any.anyAsV: jvalue\n        get() = memAllocator.alloc<jvalue> {\n            when (val origin = this@anyAsV) {\n                is Byte -> b = origin\n                is Double -> d = origin\n                is Float -> f = origin\n                is Int -> i = origin\n                is Long -> j = origin\n                is Short -> s = origin\n                is Boolean -> z = if (origin) 1u else 0u\n            }\n        }\n\n    override fun getMethodId(\n        jClass: jobject, isStatic: Boolean,\n        methodName: String, methodDesc: MethodDesc,\n    ): jmethodID = memScoped {\n        val methodId = if (isStatic) findStaticMethodPtr(\n            envPtr, jClass, methodName.cstr.ptr, methodDesc.cstr.ptr\n        ) else findMethodPtr(\n            envPtr, jClass, methodName.cstr.ptr, methodDesc.cstr.ptr\n        )\n        methodId!!\n    }\n\n    private val getBytesPtr = jEnv.GetByteArrayElements!!\n    private val getBytesLengthPtr = jEnv.GetArrayLength!!\n    private val createBytesPtr = jEnv.NewByteArray!!\n    private val releaseBytesPtr = jEnv.ReleaseByteArrayElements!!\n    override fun getBytes(jByteArray: jbyteArray): NativeProto.JBytes = memScoped {\n        val jBoolean = alloc<jbooleanVar>()\n        jBoolean.value = 0u\n        val values = getBytesPtr.invoke(envPtr, jByteArray, jBoolean.ptr)!!\n        val length = getBytesLengthPtr.invoke(envPtr, jByteArray)\n        NativeProto.JBytes(values, length)\n    }\n\n    override fun createJBytes(byteArray: ByteArray): jvalue {\n        val length = byteArray.size\n        val newArrayPtr = createBytesPtr.invoke(envPtr, length)!!\n        val valuesPointer = getBytes(newArrayPtr).valuesPointer\n        byteArray.forEachIndexed { index, byte ->\n            valuesPointer[index] = byte\n        }\n        releaseBytes(newArrayPtr, valuesPointer, true)\n        val jvalue = memAllocator.alloc<jvalue>()\n        jvalue.l = newArrayPtr\n        return jvalue\n    }\n\n    override fun releaseBytes(jByteArray: jobject, valuesPointer: CArrayPointer<ByteVar>, saveChanges: Boolean) {\n        releaseBytesPtr.invoke(envPtr, jByteArray, valuesPointer, if (saveChanges) 0 else JNI_ABORT)\n    }\n\n    override fun List<Pair<JvmBytecodeType, jvalue>>.toArrayPtr(): CArrayPointer<jvalue> {\n        val array = memAllocator.allocArray<jvalue>(size)\n        for ((index, valuePair) in withIndex()) {\n            val (bytecodeType, value) = valuePair\n            when (bytecodeType) {\n                B -> array[index].b = value.b\n                C -> array[index].c = value.c\n                D -> array[index].d = value.d\n                F -> array[index].f = value.f\n                I -> array[index].i = value.i\n                J -> array[index].j = value.j\n                S -> array[index].s = value.s\n                Z -> array[index].z = value.z\n                L -> array[index].l = value.l\n                else -> throw IllegalArgumentException(\"cannot transform type of [${bytecodeType.jniName}], value: $value\")\n            }\n        }\n        return array\n    }\n}\n";
    }
}

