/*
 * Decompiled with CFR 0.152.
 */
package zsu.cacheable.kcp.common;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.name.Name;
import zsu.cacheable.kcp.common.CacheableFuncKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lzsu/cacheable/kcp/common/CacheableFunc;", "", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)V", "backendFieldName", "Lorg/jetbrains/kotlin/name/Name;", "getBackendFieldName", "()Lorg/jetbrains/kotlin/name/Name;", "copiedOriginFunctionName", "getCopiedOriginFunctionName", "createdFlagFieldName", "getCreatedFlagFieldName", "funcDesc", "", "funcIdentifier", "getOrigin", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "returnType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getReturnType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "kotlin-cacheable-kcp"})
public class CacheableFunc {
    @NotNull
    private final IrSimpleFunction origin;
    @NotNull
    private final IrType returnType;
    @NotNull
    private final String funcIdentifier;
    @NotNull
    private final String funcDesc;
    @NotNull
    private final Name copiedOriginFunctionName;
    @NotNull
    private final Name backendFieldName;
    @NotNull
    private final Name createdFlagFieldName;

    public CacheableFunc(@NotNull IrSimpleFunction origin) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        this.origin = origin;
        this.returnType = this.origin.getReturnType();
        String string = this.origin.getName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
        this.funcIdentifier = string;
        this.funcDesc = this.funcIdentifier + "_" + CacheableFuncKt.access$generateDesc(this.origin);
        Name name = Name.identifier((String)("cachedOrigin$" + this.funcIdentifier));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        this.copiedOriginFunctionName = name;
        Name name2 = Name.identifier((String)("cachedField$" + this.funcDesc));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        this.backendFieldName = name2;
        Name name3 = Name.identifier((String)("cacheCreated$" + this.funcDesc));
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        this.createdFlagFieldName = name3;
    }

    @NotNull
    public final IrSimpleFunction getOrigin() {
        return this.origin;
    }

    @NotNull
    public final IrType getReturnType() {
        return this.returnType;
    }

    @NotNull
    public final Name getCopiedOriginFunctionName() {
        return this.copiedOriginFunctionName;
    }

    @NotNull
    public final Name getBackendFieldName() {
        return this.backendFieldName;
    }

    @NotNull
    public final Name getCreatedFlagFieldName() {
        return this.createdFlagFieldName;
    }
}

