/*
 * Decompiled with CFR 0.152.
 */
package host.fai.lib.faiNumber;

import host.fai.lib.faiNumber.EmptyStringException;

public final class Base16Util {
    private Base16Util() {
    }

    public static int toInt(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        char ch1 = input.charAt(0);
        if (ch1 == '-' || ch1 == '+') {
            if (length == 1) {
                throw new NumberFormatException(input);
            }
            start = 1;
        } else {
            start = 0;
        }
        int out = 0;
        while (start < length && input.charAt(start) == '0') {
            ++start;
        }
        int runlen = length - start;
        if (runlen > 7) {
            if (runlen > 8) {
                throw new NumberFormatException(input);
            }
            out = input.charAt(start++) ^ 0x30;
            if (ch1 == '-') {
                if (out > 7) {
                    if (out > 8) {
                        throw new NumberFormatException(input);
                    }
                    while (start < length) {
                        if (input.charAt(start) != '0') {
                            throw new NumberFormatException(input);
                        }
                        ++start;
                    }
                    return Integer.MIN_VALUE;
                }
            } else if (out > 7) {
                throw new NumberFormatException(input);
            }
        }
        while (start < length) {
            int c = input.charAt(start);
            if (c > 96 && c < 103) {
                c -= 87;
            } else if (c > 64 && c < 71) {
                c -= 55;
            } else if ((c ^= 0x30) > 9) {
                throw new NumberFormatException(input);
            }
            out = out << 4 | c;
            ++start;
        }
        if (ch1 == '-') {
            return ~out + 1;
        }
        return out;
    }

    public static int toIntAsUnsigned(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        int out = 0;
        for (start = 0; start < length && input.charAt(start) == '0'; ++start) {
        }
        if (length - start > 8) {
            throw new NumberFormatException(input);
        }
        while (start < length) {
            int c = input.charAt(start);
            if (c > 96 && c < 103) {
                c -= 87;
            } else if (c > 64 && c < 71) {
                c -= 55;
            } else if ((c ^= 0x30) > 9) {
                throw new NumberFormatException(input);
            }
            out = out << 4 | c;
            ++start;
        }
        return out;
    }

    public static long toLong(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        char ch1 = input.charAt(0);
        if (ch1 == '-' || ch1 == '+') {
            if (length == 1) {
                throw new NumberFormatException(input);
            }
            start = 1;
        } else {
            start = 0;
        }
        long out = 0L;
        while (start < length && input.charAt(start) == '0') {
            ++start;
        }
        int runlen = length - start;
        if (runlen > 15) {
            if (runlen > 16) {
                throw new NumberFormatException(input);
            }
            out = input.charAt(start++) ^ 0x30;
            if (ch1 == '-') {
                if (out > 7L) {
                    if (out > 8L) {
                        throw new NumberFormatException(input);
                    }
                    while (start < length) {
                        if (input.charAt(start) != '0') {
                            throw new NumberFormatException(input);
                        }
                        ++start;
                    }
                    return Long.MIN_VALUE;
                }
            } else if (out > 7L) {
                throw new NumberFormatException(input);
            }
        }
        while (start < length) {
            long c = input.charAt(start);
            if (c > 96L && c < 103L) {
                c -= 87L;
            } else if (c > 64L && c < 71L) {
                c -= 55L;
            } else if ((c ^= 0x30L) > 9L) {
                throw new NumberFormatException(input);
            }
            out = out << 4 | c;
            ++start;
        }
        if (ch1 == '-') {
            return (out ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
        }
        return out;
    }

    public static long toLongAsUnsigned(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        long out = 0L;
        for (start = 0; start < length && input.charAt(start) == '0'; ++start) {
        }
        if (length - start > 16) {
            throw new NumberFormatException(input);
        }
        while (start < length) {
            long c = input.charAt(start);
            if (c > 96L && c < 103L) {
                c -= 87L;
            } else if (c > 64L && c < 71L) {
                c -= 55L;
            } else if ((c ^= 0x30L) > 9L) {
                throw new NumberFormatException(input);
            }
            out = out << 4 | c;
            ++start;
        }
        return out;
    }
}

