/*
 * Decompiled with CFR 0.152.
 */
package host.fai.lib.faiNumber;

import host.fai.lib.faiNumber.EmptyStringException;

public final class Base3Util {
    private Base3Util() {
    }

    public static final int toInt(String input) {
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        char ch1 = input.charAt(0);
        int start = 0;
        if (ch1 == '-' || ch1 == '+') {
            if (length == 1) {
                throw new NumberFormatException(input);
            }
            start = 1;
        }
        int out = 0;
        while (start < length && input.charAt(start) == '0') {
            ++start;
        }
        int runlen = length - start;
        if (runlen > 19) {
            if (runlen > 20) {
                throw new NumberFormatException(input);
            }
            if ((out = input.charAt(start++) ^ 0x30) > 1) {
                throw new NumberFormatException(input);
            }
            while (start < length) {
                int c = input.charAt(start) ^ 0x30;
                if (c > 2) {
                    throw new NumberFormatException(input);
                }
                out = (out << 1) + out + c;
                ++start;
            }
            if (ch1 == '-') {
                if ((out = ~out + 1) > -1) {
                    throw new NumberFormatException(input);
                }
                return out;
            }
            if (out < 0) {
                throw new NumberFormatException(input);
            }
            return out;
        }
        while (start < length) {
            int c = input.charAt(start) ^ 0x30;
            if (c > 2) {
                throw new NumberFormatException(input);
            }
            out = (out << 1) + out + c;
            ++start;
        }
        if (ch1 == '-') {
            return ~out + 1;
        }
        return out;
    }

    public static final int toIntAsUnsigned(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        int out = 0;
        for (start = 0; start < length && input.charAt(start) == '0'; ++start) {
        }
        int runlen = length - start;
        if (runlen > 20) {
            if (runlen > 21) {
                throw new NumberFormatException(input);
            }
            if (input.charAt(start++) != '1') {
                throw new NumberFormatException(input);
            }
            if (input.charAt(start++) != '0') {
                throw new NumberFormatException(input);
            }
            out = 3;
            while (start < length) {
                int c = input.charAt(start) ^ 0x30;
                if (c > 2) {
                    throw new NumberFormatException(input);
                }
                out = (out << 1) + out + c;
                ++start;
            }
            if (out > -1) {
                throw new NumberFormatException(input);
            }
            return out;
        }
        while (start < length) {
            int c = input.charAt(start) ^ 0x30;
            if (c > 2) {
                throw new NumberFormatException(input);
            }
            out = (out << 1) + out + c;
            ++start;
        }
        return out;
    }

    public static final long toLong(String input) {
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        char ch1 = input.charAt(0);
        int start = 0;
        if (ch1 == '-' || ch1 == '+') {
            if (length == 1) {
                throw new NumberFormatException(input);
            }
            start = 1;
        }
        long out = 0L;
        while (start < length && input.charAt(start) == '0') {
            ++start;
        }
        int runlen = length - start;
        if (runlen > 39) {
            if (runlen > 40) {
                throw new NumberFormatException(input);
            }
            while (start < length) {
                long c = input.charAt(start) ^ 0x30;
                if (c > 2L) {
                    throw new NumberFormatException(input);
                }
                out = (out << 1) + out + c;
                ++start;
            }
            if (ch1 == '-') {
                if ((out = (out ^ 0xFFFFFFFFFFFFFFFFL) + 1L) > -1L) {
                    throw new NumberFormatException(input);
                }
                return out;
            }
            if (out < 0L) {
                throw new NumberFormatException(input);
            }
            return out;
        }
        while (start < length) {
            long c = input.charAt(start) ^ 0x30;
            if (c > 2L) {
                throw new NumberFormatException(input);
            }
            out = (out << 1) + out + c;
            ++start;
        }
        if (ch1 == '-') {
            return (out ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
        }
        return out;
    }

    public static final long toLongAsUnsigned(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        long out = 0L;
        for (start = 0; start < length && input.charAt(start) == '0'; ++start) {
        }
        int runlen = length - start;
        if (runlen > 40) {
            if (runlen > 41) {
                throw new NumberFormatException(input);
            }
            if ((out = (long)(input.charAt(start++) ^ 0x30)) != 1L) {
                throw new NumberFormatException(input);
            }
            while (start < length) {
                long c = input.charAt(start) ^ 0x30;
                if (c > 2L) {
                    throw new NumberFormatException(input);
                }
                out = (out << 1) + out + c;
                ++start;
            }
            if (out > -1L) {
                throw new NumberFormatException(input);
            }
            return out;
        }
        while (start < length) {
            long c = input.charAt(start) ^ 0x30;
            if (c > 2L) {
                throw new NumberFormatException(input);
            }
            out = (out << 1) + out + c;
            ++start;
        }
        return out;
    }
}

