/*
 * Decompiled with CFR 0.152.
 */
package host.fai.lib.faiNumber;

import host.fai.lib.faiNumber.EmptyStringException;

public final class Base8Util {
    private Base8Util() {
    }

    public static int toInt(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        char ch1 = input.charAt(0);
        if (ch1 == '-' || ch1 == '+') {
            if (length == 1) {
                throw new NumberFormatException(input);
            }
            start = 1;
        } else {
            start = 0;
        }
        int out = 0;
        while (start < length && input.charAt(start) == '0') {
            ++start;
        }
        int runlen = length - start;
        if (runlen > 10) {
            if (runlen > 11) {
                throw new NumberFormatException(input);
            }
            if ((out = input.charAt(start++) ^ 0x30) > 1) {
                if (out > 2) {
                    throw new NumberFormatException(input);
                }
                if (ch1 != '-') {
                    throw new NumberFormatException(input);
                }
                while (start < length) {
                    if (input.charAt(start) != '0') {
                        throw new NumberFormatException(input);
                    }
                    ++start;
                }
                return Integer.MIN_VALUE;
            }
        }
        while (start < length) {
            int c = input.charAt(start) ^ 0x30;
            if (c > 7) {
                throw new NumberFormatException(input);
            }
            out = out << 3 | c;
            ++start;
        }
        if (ch1 == '-') {
            return ~out + 1;
        }
        return out;
    }

    public static int toIntAsUnsigned(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        int out = 0;
        for (start = 0; start < length && input.charAt(start) == '0'; ++start) {
        }
        int runlen = length - start;
        if (runlen > 10) {
            if (runlen > 11) {
                throw new NumberFormatException(input);
            }
            if ((out = input.charAt(start++) ^ 0x30) > 3) {
                throw new NumberFormatException(input);
            }
        }
        while (start < length) {
            int c = input.charAt(start) ^ 0x30;
            if (c > 7) {
                throw new NumberFormatException(input);
            }
            out = out << 3 | c;
            ++start;
        }
        return out;
    }

    public static long toLong(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        char ch1 = input.charAt(0);
        if (ch1 == '-' || ch1 == '+') {
            if (length == 1) {
                throw new NumberFormatException(input);
            }
            start = 1;
        } else {
            start = 0;
        }
        long out = 0L;
        while (start < length && input.charAt(start) == '0') {
            ++start;
        }
        int runlen = length - start;
        if (runlen > 21) {
            if (runlen > 22) {
                throw new NumberFormatException(input);
            }
            if (ch1 != '-') {
                throw new NumberFormatException(input);
            }
            if ((input.charAt(start++) ^ 0x30) > 1) {
                throw new NumberFormatException(input);
            }
            while (start < length) {
                if (input.charAt(start) != '0') {
                    throw new NumberFormatException(input);
                }
                ++start;
            }
            return Long.MIN_VALUE;
        }
        while (start < length) {
            long c = input.charAt(start) ^ 0x30;
            if (c > 7L) {
                throw new NumberFormatException(input);
            }
            out = out << 3 | c;
            ++start;
        }
        if (ch1 == '-') {
            return (out ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
        }
        return out;
    }

    public static long toLongAsUnsigned(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        long out = 0L;
        for (start = 0; start < length && input.charAt(start) == '0'; ++start) {
        }
        int runlen = length - start;
        if (runlen > 21) {
            if (runlen > 22) {
                throw new NumberFormatException(input);
            }
            out = input.charAt(start) ^ 0x30;
            if (out > 1L) {
                throw new NumberFormatException(input);
            }
        }
        while (start < length) {
            long c = input.charAt(start) ^ 0x30;
            if (c > 7L) {
                throw new NumberFormatException(input);
            }
            out = out << 3 | c;
            ++start;
        }
        return out;
    }
}

