/*
 * Decompiled with CFR 0.152.
 */
package host.fai.lib.faiNumber;

import host.fai.lib.faiNumber.EmptyStringException;

public final class HexUtil {
    private HexUtil() {
    }

    public static int toInt(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        int out = 0;
        for (start = 0; start < length && input.charAt(start) == '0'; ++start) {
        }
        if (length - start > 8) {
            throw new NumberFormatException(input);
        }
        while (start < length) {
            int c = input.charAt(start);
            if (c > 96 & c < 103) {
                c -= 87;
            } else if (c > 64 && c < 71) {
                c -= 55;
            } else if ((c ^= 0x30) > 9) {
                throw new NumberFormatException(input);
            }
            out = out << 4 | c;
            ++start;
        }
        return out;
    }

    public static long toLong(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        long out = 0L;
        for (start = 0; start < length && input.charAt(start) == '0'; ++start) {
        }
        if (length - start > 16) {
            throw new NumberFormatException(input);
        }
        while (start < length) {
            long c = input.charAt(start);
            if (c > 96L && c < 103L) {
                c -= 87L;
            } else if (c > 64L && c < 71L) {
                c -= 55L;
            } else if ((c ^= 0x30L) > 9L) {
                throw new NumberFormatException(input);
            }
            out = out << 4 | c;
            ++start;
        }
        return out;
    }
}

