/*
 * Decompiled with CFR 0.152.
 */
package host.fai.lib.faiNumber;

public final class IntUtil {
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private IntUtil() {
    }

    public static boolean isOdd(int input) {
        return (input & 1) == 1;
    }

    public static boolean isEven(int input) {
        return (input & 1) == 0;
    }

    public static String toSignedBinary(int input) {
        char[] out = new char[32];
        int pos = 32;
        if (input < 0) {
            if (input == Integer.MIN_VALUE) {
                return "-10000000000000000000000000000000";
            }
            for (input = (input ^ 0xFFFFFFFF) + 1; input != 0; input >>= 1) {
                out[--pos] = (char)(input & 1 ^ 0x30);
            }
            out[--pos] = 45;
        } else if (input > 0) {
            while (input != 0) {
                out[--pos] = (char)(input & 1 ^ 0x30);
                input >>= 1;
            }
        } else {
            return "0";
        }
        return new String(out, pos, 32 - pos);
    }

    public static String toSignedOctal(int input) {
        char[] out = new char[12];
        int pos = 12;
        if (input < 0) {
            if (input == Integer.MIN_VALUE) {
                return "-20000000000";
            }
            for (input = (input ^ 0xFFFFFFFF) + 1; input != 0; input >>= 3) {
                out[--pos] = (char)(input & 7 ^ 0x30);
            }
            out[--pos] = 45;
        } else if (input > 0) {
            while (input != 0) {
                out[--pos] = (char)(input & 7 ^ 0x30);
                input >>= 3;
            }
        } else {
            return "0";
        }
        return new String(out, pos, 12 - pos);
    }

    public static String toSignedHex(int input) {
        char[] out = new char[9];
        int pos = 9;
        if (input < 0) {
            if (input == Integer.MIN_VALUE) {
                return "-80000000";
            }
            for (input = (input ^ 0xFFFFFFFF) + 1; input != 0; input >>= 4) {
                out[--pos] = digits[input & 0xF];
            }
            out[--pos] = 45;
        } else if (input > 0) {
            while (input != 0) {
                out[--pos] = digits[input & 0xF];
                input >>= 4;
            }
        } else {
            return "0";
        }
        return new String(out, pos, 9 - pos);
    }

    public static String toStringAsUnsigned(int input) {
        long out = 0L;
        if ((input & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            out |= 0x80000000L;
        }
        return Long.toString(out |= (long)(input & Integer.MAX_VALUE));
    }

    public static long toLongAsUnsigned(int input) {
        long out = 0L;
        if ((input & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            out |= 0x80000000L;
        }
        return out | (long)(input & Integer.MAX_VALUE);
    }
}

