/*
 * Decompiled with CFR 0.152.
 */
package host.fai.lib.faiNumber;

public final class LongUtil {
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private LongUtil() {
    }

    public static boolean isOdd(long input) {
        return (input & 1L) == 1L;
    }

    public static boolean isEven(long input) {
        return (input & 1L) == 0L;
    }

    public static String toSignedBinary(long input) {
        char[] out = new char[64];
        int pos = 64;
        if (input < 0L) {
            if (input == Long.MIN_VALUE) {
                return "-1000000000000000000000000000000000000000000000000000000000000000";
            }
            for (input = (input ^ 0xFFFFFFFFFFFFFFFFL) + 1L; input != 0L; input >>= 1) {
                out[--pos] = (char)(input & 1L ^ 0x30L);
            }
            out[--pos] = 45;
        } else if (input > 0L) {
            while (input != 0L) {
                out[--pos] = (char)(input & 1L ^ 0x30L);
                input >>= 1;
            }
        } else {
            return "0";
        }
        return new String(out, pos, 64 - pos);
    }

    public static String toSignedOctal(long input) {
        char[] out = new char[23];
        int pos = 23;
        if (input < 0L) {
            if (input == Long.MIN_VALUE) {
                return "-1000000000000000000000";
            }
            for (input = (input ^ 0xFFFFFFFFFFFFFFFFL) + 1L; input != 0L; input >>= 3) {
                out[--pos] = (char)(input & 7L ^ 0x30L);
            }
            out[--pos] = 45;
        } else if (input > 0L) {
            while (input != 0L) {
                out[--pos] = (char)(input & 7L ^ 0x30L);
                input >>= 3;
            }
        } else {
            return "0";
        }
        return new String(out, pos, 23 - pos);
    }

    public static String toSignedHex(long input) {
        char[] out = new char[17];
        int pos = 17;
        if (input < 0L) {
            if (input == Long.MIN_VALUE) {
                return "-8000000000000000";
            }
            for (input = (input ^ 0xFFFFFFFFFFFFFFFFL) + 1L; input != 0L; input >>= 4) {
                out[--pos] = digits[(int)(input & 0xFL)];
            }
            out[--pos] = 45;
        } else if (input > 0L) {
            while (input != 0L) {
                out[--pos] = digits[(int)(input & 0xFL)];
                input >>= 4;
            }
        } else {
            return "0";
        }
        return new String(out, pos, 17 - pos);
    }

    public static String toStringAsUnsigned(long input) {
        if (input == 0L) {
            return "0";
        }
        char[] out = new char[20];
        int pos = 20;
        while (input != 0L) {
            long quotient = 0L;
            int remainder = 0;
            for (int i = 63; i > -1; --i) {
                remainder <<= 1;
                long shift = 1L << i;
                if ((input & shift) != 0L) {
                    remainder |= 1;
                }
                if (remainder <= 9) continue;
                remainder -= 10;
                quotient |= shift;
            }
            out[--pos] = digits[remainder];
            input = quotient;
        }
        return new String(out, pos, 20 - pos);
    }
}

