/*
 * Decompiled with CFR 0.152.
 */
package host.fai.lib.faiNumber;

import host.fai.lib.faiNumber.EmptyStringException;

public final class OctalUtil {
    private OctalUtil() {
    }

    public static int toInt(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        int out = 0;
        for (start = 0; start < length && input.charAt(start) == '0'; ++start) {
        }
        int runlen = length - start;
        if (runlen > 10) {
            if (runlen > 11) {
                throw new NumberFormatException(input);
            }
            if ((out = input.charAt(start++) ^ 0x30) > 3) {
                throw new NumberFormatException(input);
            }
        }
        while (start < length) {
            int c = input.charAt(start) ^ 0x30;
            if (c > 7) {
                throw new NumberFormatException(input);
            }
            out = out << 3 | c;
            ++start;
        }
        return out;
    }

    public static long toLong(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        long out = 0L;
        for (start = 0; start < length && input.charAt(start) == '0'; ++start) {
        }
        int runlen = length - start;
        if (runlen > 21) {
            if (runlen > 22) {
                throw new NumberFormatException(input);
            }
            out = input.charAt(start) ^ 0x30;
            if (out > 1L) {
                throw new NumberFormatException(input);
            }
        }
        while (start < length) {
            long c = input.charAt(start) ^ 0x30;
            if (c > 7L) {
                throw new NumberFormatException(input);
            }
            out = out << 3 | c;
            ++start;
        }
        return out;
    }
}

