/*
 * Decompiled with CFR 0.152.
 */
package host.fai.lib.faiNumber;

import host.fai.lib.faiNumber.EmptyStringException;
import host.fai.lib.faiNumber.NumberOverFlowException;
import host.fai.lib.faiNumber.NumberUnderFlowException;

public final class Base10Util {
    private Base10Util() {
    }

    public static final int toInt(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        char c1 = input.charAt(0);
        if (c1 == '-' || c1 == '+') {
            if (length == 1) {
                throw new NumberFormatException(input);
            }
            start = 1;
        } else {
            start = 0;
        }
        int out = 0;
        while (start < length && input.charAt(start) == '0') {
            ++start;
        }
        int runlen = length - start;
        if (runlen > 9) {
            if (runlen > 10) {
                throw new NumberFormatException(input);
            }
            if ((out = input.charAt(start++) ^ 0x30) > 2) {
                throw new NumberFormatException(input);
            }
        }
        while (start < length) {
            int c = input.charAt(start) ^ 0x30;
            if (c > 9) {
                throw new NumberFormatException(input);
            }
            out = (out << 1) + (out << 3) + c;
            ++start;
        }
        if (c1 == '-') {
            if ((out = ~out + 1) > 0) {
                throw new NumberFormatException(input);
            }
            return out;
        }
        if (out < 0) {
            throw new NumberFormatException(input);
        }
        return out;
    }

    public static final int toIntTrueError(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException(input);
        }
        char c1 = input.charAt(0);
        if (c1 == '-' || c1 == '+') {
            if (length == 1) {
                throw new NumberFormatException(input);
            }
            start = 1;
        } else {
            start = 0;
        }
        int out = 0;
        while (start < length && input.charAt(start) == '0') {
            ++start;
        }
        int runlen = length - start;
        if (runlen > 9) {
            if (runlen > 10) {
                while (start < length) {
                    if ((input.charAt(start) ^ 0x30) > 9) {
                        throw new NumberFormatException(input);
                    }
                    ++start;
                }
                Base10Util.throwUnderOverError(c1, input);
            }
            if ((out = input.charAt(start++) ^ 0x30) > 9) {
                throw new NumberFormatException(input);
            }
            if (out > 2) {
                Base10Util.throwUnderOverError(c1, input);
            }
        }
        while (start < length) {
            int c = input.charAt(start) ^ 0x30;
            if (c > 9) {
                throw new NumberFormatException(input);
            }
            out = (out << 1) + (out << 3) + c;
            ++start;
        }
        if (c1 == '-') {
            if ((out = ~out + 1) > 0) {
                throw new NumberUnderFlowException(input);
            }
            return out;
        }
        if (out < 0) {
            throw new NumberOverFlowException(input);
        }
        return out;
    }

    public static final int toIntAsUnsigned(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException(input);
        }
        boolean checkOverFlow = false;
        int out = 0;
        for (start = 0; start < length && input.charAt(start) == '0'; ++start) {
        }
        int runlen = length - start;
        if (runlen > 9) {
            if (runlen > 10) {
                throw new NumberFormatException(input);
            }
            if ((out = input.charAt(start++) ^ 0x30) > 3) {
                if (out > 4) {
                    throw new NumberFormatException(input);
                }
                checkOverFlow = true;
            }
            while (start < length) {
                int c = input.charAt(start) ^ 0x30;
                if (c > 9) {
                    throw new NumberFormatException(input);
                }
                out = (out << 1) + (out << 3) + c;
                ++start;
            }
            if (checkOverFlow && out > -1) {
                throw new NumberFormatException(input);
            }
            return out;
        }
        while (start < length) {
            int c = input.charAt(start) ^ 0x30;
            if (c > 9) {
                throw new NumberFormatException(input);
            }
            out = (out << 1) + (out << 3) + c;
            ++start;
        }
        return out;
    }

    public static final long toLong(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        char c1 = input.charAt(0);
        if (c1 == '-' || c1 == '+') {
            if (length == 1) {
                throw new NumberFormatException(input);
            }
            start = 1;
        } else {
            start = 0;
        }
        long out = 0L;
        while (start < length && input.charAt(start) == '0') {
            ++start;
        }
        if (length - start > 19) {
            throw new NumberFormatException(input);
        }
        while (start < length) {
            long c = input.charAt(start) ^ 0x30;
            if (c > 9L) {
                throw new NumberFormatException(input);
            }
            out = (out << 1) + (out << 3) + c;
            ++start;
        }
        if (c1 == '-') {
            if ((out = (out ^ 0xFFFFFFFFFFFFFFFFL) + 1L) > 0L) {
                throw new NumberFormatException(input);
            }
            return out;
        }
        if (out < 0L) {
            throw new NumberFormatException(input);
        }
        return out;
    }

    public static final long toLongTrueError(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        char c1 = input.charAt(0);
        if (c1 == '-' || c1 == '+') {
            if (length == 1) {
                throw new NumberFormatException(input);
            }
            start = 1;
        } else {
            start = 0;
        }
        long out = 0L;
        while (start < length && input.charAt(start) == '0') {
            ++start;
        }
        if (length - start > 19) {
            while (start < length) {
                if ((input.charAt(start) ^ 0x30) > 9) {
                    throw new NumberFormatException(input);
                }
                ++start;
            }
            Base10Util.throwUnderOverError(c1, input);
        }
        while (start < length) {
            long c = input.charAt(start) ^ 0x30;
            if (c > 9L) {
                throw new NumberFormatException(input);
            }
            out = (out << 1) + (out << 3) + c;
            ++start;
        }
        if (c1 == '-') {
            if ((out = (out ^ 0xFFFFFFFFFFFFFFFFL) + 1L) > 0L) {
                throw new NumberUnderFlowException(input);
            }
            return out;
        }
        if (out < 0L) {
            throw new NumberOverFlowException(input);
        }
        return out;
    }

    public static final long toLongAsUnsigned(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        long out = 0L;
        for (start = 0; start < length && input.charAt(start) == '0'; ++start) {
        }
        int runlen = length - start;
        if (runlen > 19) {
            if (runlen > 20) {
                throw new NumberFormatException(input);
            }
            if ((out = (long)(input.charAt(start++) ^ 0x30)) > 1L) {
                throw new NumberFormatException(input);
            }
            while (start < length) {
                long c = input.charAt(start) ^ 0x30;
                if (c > 9L) {
                    throw new NumberFormatException(input);
                }
                out = (out << 1) + (out << 3) + c;
                ++start;
            }
            if (out > -1L) {
                throw new NumberFormatException(input);
            }
            return out;
        }
        while (start < length) {
            long c = input.charAt(start) ^ 0x30;
            if (c > 9L) {
                throw new NumberFormatException(input);
            }
            out = (out << 1) + (out << 3) + c;
            ++start;
        }
        return out;
    }

    public static int compareAsInt(String firstNumber, String secondNumber) {
        int n2;
        int n1 = Base10Util.toInt(firstNumber);
        if (n1 > (n2 = Base10Util.toInt(secondNumber))) {
            return 1;
        }
        if (n1 < n2) {
            return -1;
        }
        return 0;
    }

    public static int intOrSmaller(String firstNumber, String secondNumber) {
        int n2p;
        int n1p;
        if (firstNumber.length() == 0) {
            if (secondNumber.length() == 0) {
                return 0;
            }
            try {
                Base10Util.toInt(secondNumber);
                return -1;
            }
            catch (NumberFormatException e) {
                return 1;
            }
        }
        if (secondNumber.length() == 0) {
            try {
                Base10Util.toInt(firstNumber);
                return 1;
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        int n1 = 0;
        int n2 = 0;
        try {
            n1 = Base10Util.toIntTrueError(firstNumber);
            n1p = 4;
        }
        catch (NumberFormatException e) {
            n1p = 0;
        }
        catch (NumberUnderFlowException e) {
            n1p = 1;
        }
        catch (NumberOverFlowException e) {
            n1p = 2;
        }
        try {
            n2 = Base10Util.toIntTrueError(secondNumber);
            n2p = 4;
        }
        catch (NumberFormatException e) {
            n2p = 0;
        }
        catch (NumberUnderFlowException e) {
            n2p = 1;
        }
        catch (NumberOverFlowException e) {
            n2p = 2;
        }
        if (n1p == 4 && n2p == 4) {
            if (n1 > n2) {
                return 1;
            }
            if (n1 < n2) {
                return -1;
            }
            return 0;
        }
        if (n1p > n2p) {
            return 1;
        }
        if (n1p < n2p) {
            return -1;
        }
        return 0;
    }

    public static int compareAsLong(String firstNumber, String secondNumber) {
        long n2;
        long n1 = Base10Util.toLong(firstNumber);
        if (n1 > (n2 = Base10Util.toLong(secondNumber))) {
            return 1;
        }
        if (n1 < n2) {
            return -1;
        }
        return 0;
    }

    public static int longOrSmaller(String firstNumber, String secondNumber) {
        int n2p;
        int n1p;
        if (firstNumber.length() == 0) {
            if (secondNumber.length() == 0) {
                return 0;
            }
            try {
                Base10Util.toLong(secondNumber);
                return -1;
            }
            catch (NumberFormatException e) {
                return 1;
            }
        }
        if (secondNumber.length() == 0) {
            try {
                Base10Util.toLong(firstNumber);
                return 1;
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        long n1 = 0L;
        long n2 = 0L;
        try {
            n1 = Base10Util.toLongTrueError(firstNumber);
            n1p = 4;
        }
        catch (NumberFormatException e) {
            n1p = 0;
        }
        catch (NumberUnderFlowException e) {
            n1p = 1;
        }
        catch (NumberOverFlowException e) {
            n1p = 2;
        }
        try {
            n2 = Base10Util.toLongTrueError(secondNumber);
            n2p = 4;
        }
        catch (NumberFormatException e) {
            n2p = 0;
        }
        catch (NumberUnderFlowException e) {
            n2p = 1;
        }
        catch (NumberOverFlowException e) {
            n2p = 2;
        }
        if (n1p == 4 && n2p == 4) {
            if (n1 > n2) {
                return 1;
            }
            if (n1 < n2) {
                return -1;
            }
            return 0;
        }
        if (n1p > n2p) {
            return 1;
        }
        if (n1p < n2p) {
            return -1;
        }
        return 0;
    }

    private static final void throwUnderOverError(char c, String str) {
        if (c == '-') {
            throw new NumberUnderFlowException(str);
        }
        throw new NumberOverFlowException(str);
    }
}

