/*
 * Decompiled with CFR 0.152.
 */
package host.fai.lib.faiNumber;

import host.fai.lib.faiNumber.EmptyStringException;

public final class Base2Util {
    private Base2Util() {
    }

    public static final int toInt(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        char ch1 = input.charAt(0);
        if (ch1 == '-' || ch1 == '+') {
            if (length == 1) {
                throw new NumberFormatException(input);
            }
            start = 1;
        } else {
            start = 0;
        }
        int out = 0;
        while (start < length && input.charAt(start) == '0') {
            ++start;
        }
        int runlen = length - start;
        if (runlen > 31) {
            if (runlen > 32) {
                throw new NumberFormatException(input);
            }
            if (ch1 != '-') {
                throw new NumberFormatException(input);
            }
            if (input.charAt(start++) != '1') {
                throw new NumberFormatException(input);
            }
            while (start < length) {
                if (input.charAt(start) != '0') {
                    throw new NumberFormatException(input);
                }
                ++start;
            }
            return Integer.MIN_VALUE;
        }
        while (start < length) {
            int c = input.charAt(start) ^ 0x30;
            if (c > 1) {
                throw new NumberFormatException(input);
            }
            out = out << 1 | c;
            ++start;
        }
        if (ch1 == '-') {
            return ~out + 1;
        }
        return out;
    }

    public static final int toIntAsUnsigned(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        int out = 0;
        for (start = 0; start < length && input.charAt(start) == '0'; ++start) {
        }
        if (length - start > 32) {
            throw new NumberFormatException(input);
        }
        while (start < length) {
            int c = input.charAt(start) ^ 0x30;
            if (c > 1) {
                throw new NumberFormatException(input);
            }
            out = out << 1 | c;
            ++start;
        }
        return out;
    }

    public static final long toLong(String input) {
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        char ch1 = input.charAt(0);
        int start = 0;
        if (ch1 == '-' || ch1 == '+') {
            if (length == 1) {
                throw new NumberFormatException(input);
            }
            start = 1;
        }
        long out = 0L;
        while (start < length && input.charAt(start) == '0') {
            ++start;
        }
        int runlen = length - start;
        if (runlen > 63) {
            if (runlen > 64) {
                throw new NumberFormatException(input);
            }
            if (ch1 != '-') {
                throw new NumberFormatException(input);
            }
            if (input.charAt(start++) != '1') {
                throw new NumberFormatException(input);
            }
            while (start < length) {
                if (input.charAt(start) != '0') {
                    throw new NumberFormatException(input);
                }
                ++start;
            }
            return Long.MIN_VALUE;
        }
        while (start < length) {
            long c = input.charAt(start) ^ 0x30;
            if (c > 1L) {
                throw new NumberFormatException(input);
            }
            out = out << 1 | c;
            ++start;
        }
        if (ch1 == '-') {
            return (out ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
        }
        return out;
    }

    public static final long toLongAsUnsigned(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        long out = 0L;
        for (start = 0; start < length && input.charAt(start) == '0'; ++start) {
        }
        if (length - start > 64) {
            throw new NumberFormatException(input);
        }
        while (start < length) {
            long c = input.charAt(start) ^ 0x30;
            if (c > 1L) {
                throw new NumberFormatException(input);
            }
            out = out << 1 | c;
            ++start;
        }
        return out;
    }
}

