/*
 * Decompiled with CFR 0.152.
 */
package host.fai.lib.faiNumber;

import host.fai.lib.faiNumber.EmptyStringException;

public final class BinaryUtil {
    private BinaryUtil() {
    }

    public static final int toInt(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        int out = 0;
        for (start = 0; start < length && input.charAt(start) == '0'; ++start) {
        }
        if (length - start > 32) {
            throw new NumberFormatException(input);
        }
        while (start < length) {
            int c = input.charAt(start) ^ 0x30;
            if (c > 1) {
                throw new NumberFormatException(input);
            }
            out = out << 1 | c;
            ++start;
        }
        return out;
    }

    public static final long toLong(String input) {
        int start;
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        long out = 0L;
        for (start = 0; start < length && input.charAt(start) == '0'; ++start) {
        }
        if (length - start > 64) {
            throw new NumberFormatException(input);
        }
        while (start < length) {
            long c = input.charAt(start) ^ 0x30;
            if (c > 1L) {
                throw new NumberFormatException(input);
            }
            out = out << 1 | c;
            ++start;
        }
        return out;
    }
}

