/*
 * Decompiled with CFR 0.152.
 */
package host.fai.lib.faiNumber;

import host.fai.lib.faiNumber.EmptyStringException;

public final class NumberStringUtil {
    private NumberStringUtil() {
    }

    public static boolean isInteger(String input) {
        int first;
        int length = input.length();
        if (length == 0) {
            return false;
        }
        if (input.charAt(0) == '-' || input.charAt(0) == '+') {
            if (length == 1) {
                return false;
            }
            first = 1;
        } else {
            first = 0;
        }
        while (length-- > first) {
            if ((input.charAt(length) ^ 0x30) <= 9) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnsignedInteger(String input) {
        int length = input.length();
        if (length == 0) {
            return false;
        }
        while (length-- > 0) {
            if ((input.charAt(length) ^ 0x30) <= 9) continue;
            return false;
        }
        return true;
    }

    public static boolean isBinary(String input) {
        int first;
        int length = input.length();
        if (length == 0) {
            return false;
        }
        if (input.charAt(0) == '-' || input.charAt(0) == '+') {
            if (length == 1) {
                return false;
            }
            first = 1;
        } else {
            first = 0;
        }
        while (length-- > first) {
            if ((input.charAt(length) ^ 0x30) <= 1) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnsignedBinary(String input) {
        int length = input.length();
        if (length == 0) {
            return false;
        }
        while (length-- > 0) {
            if ((input.charAt(length) ^ 0x30) <= 1) continue;
            return false;
        }
        return true;
    }

    public static boolean isOctal(String input) {
        int first;
        int length = input.length();
        if (length == 0) {
            return false;
        }
        if (input.charAt(0) == '-' || input.charAt(0) == '+') {
            if (length == 1) {
                return false;
            }
            first = 1;
        } else {
            first = 0;
        }
        while (length-- > first) {
            if ((input.charAt(length) ^ 0x30) <= 7) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnsignedOctal(String input) {
        int length = input.length();
        if (length == 0) {
            return false;
        }
        while (length-- > 0) {
            if ((input.charAt(length) ^ 0x30) <= 7) continue;
            return false;
        }
        return true;
    }

    public static boolean isHex(String input) {
        int first;
        int length = input.length();
        if (length == 0) {
            return false;
        }
        if (input.charAt(0) == '-' || input.charAt(0) == '+') {
            if (length == 1) {
                return false;
            }
            first = 1;
        } else {
            first = 0;
        }
        while (length-- > first) {
            int c = input.charAt(length);
            if (c > 96 & c < 103 || c > 64 && c < 71 || (c ^= 0x30) <= 9) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnsignedHex(String input) {
        int length = input.length();
        if (length == 0) {
            return false;
        }
        while (length-- > 0) {
            int c = input.charAt(length);
            if (c > 96 && c < 103 || c > 64 && c < 71 || (c ^= 0x30) <= 9) continue;
            return false;
        }
        return true;
    }

    public static boolean isBase(String input, int base) {
        int first;
        if (base < 2 || base > 36) {
            throw new UnsupportedOperationException("Unsupported base. Input base: " + base + ".");
        }
        int length = input.length();
        if (length == 0) {
            return false;
        }
        if (input.charAt(0) == '-' || input.charAt(0) == '+') {
            if (length == 1) {
                return false;
            }
            first = 1;
        } else {
            first = 0;
        }
        while (length-- > first) {
            int c = input.charAt(length);
            if (c > 96) {
                c -= 87;
            } else if (c > 64) {
                c -= 55;
            } else if ((c ^= 0x30) > 9) {
                return false;
            }
            if (c < base) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnsignedBase(String input, int base) {
        if (base < 2 || base > 36) {
            throw new UnsupportedOperationException("Unsupported base. Input base: " + base + ".");
        }
        int length = input.length();
        if (length == 0) {
            return false;
        }
        while (length-- > 0) {
            int c = input.charAt(length);
            if (c > 96) {
                c -= 87;
            } else if (c > 64) {
                c -= 55;
            } else if ((c ^= 0x30) > 9) {
                return false;
            }
            if (c < base) continue;
            return false;
        }
        return true;
    }

    public static boolean isDigit(char input) {
        return (input ^ 0x30) < 10;
    }

    public static boolean isBinaryDigit(char input) {
        return input == '0' || input == '1';
    }

    public static boolean isOctalDigit(char input) {
        return (input ^ 0x30) < 8;
    }

    public static boolean isHexDigit(char input) {
        return input > '/' && input < ':' || input > '@' && input < 'G' || input > '`' && input < 'g';
    }

    public static boolean isBaseDigit(char input, int base) {
        if (base < 2 || base > 36) {
            throw new UnsupportedOperationException("Unsupported base. Input base: " + base + ".");
        }
        if (input > '`') {
            input = (char)(input - 87);
        } else if (input > '@') {
            input = (char)(input - 55);
        } else if ((input = (char)(input ^ 0x30)) > '\t') {
            return false;
        }
        return input < base;
    }

    public static boolean assumeIsOdd(String input) {
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        return (input.charAt(length - 1) & '\u0001') != 0;
    }

    public static boolean assumeIsEven(String input) {
        int length = input.length();
        if (length == 0) {
            throw new EmptyStringException();
        }
        return (input.charAt(length - 1) & '\u0001') == 0;
    }

    public static int assumeCompare(String firstString, String secondString) {
        block28: {
            int runlen2;
            int runlen1;
            int start2;
            int start1;
            boolean neg1;
            block27: {
                int str1length = firstString.length();
                int str2length = secondString.length();
                if (str1length == 0) {
                    if (str2length == 0) {
                        return 0;
                    }
                    return -1;
                }
                if (str2length == 0) {
                    return 1;
                }
                neg1 = false;
                boolean neg2 = false;
                start1 = 0;
                start2 = 0;
                if (firstString.charAt(0) == '-') {
                    neg1 = true;
                    start1 = 1;
                } else if (firstString.charAt(0) == '+') {
                    start1 = 1;
                }
                if (secondString.charAt(0) == '-') {
                    neg2 = true;
                    start2 = 1;
                } else if (secondString.charAt(0) == '+') {
                    start2 = 1;
                }
                while (start1 < str1length && firstString.charAt(start1) == '0') {
                    ++start1;
                }
                while (start2 < str2length && secondString.charAt(start2) == '0') {
                    ++start2;
                }
                runlen1 = str1length - start1;
                runlen2 = str2length - start2;
                if (runlen1 == 0) {
                    if (runlen2 == 0) {
                        return 0;
                    }
                    if (neg2) {
                        return 1;
                    }
                    return -1;
                }
                if (runlen2 == 0) {
                    if (neg1) {
                        return -1;
                    }
                    return 1;
                }
                if (neg1 != neg2) {
                    if (!neg1) {
                        return 1;
                    }
                    if (neg1) {
                        return -1;
                    }
                }
                if (!neg1) break block27;
                if (runlen1 > runlen2) {
                    return -1;
                }
                if (runlen1 < runlen2) {
                    return 1;
                }
                while (runlen1-- != 0) {
                    char c2;
                    char c1;
                    if ((c1 = firstString.charAt(start1++)) < (c2 = secondString.charAt(start2++))) {
                        return 1;
                    }
                    if (c1 <= c2) continue;
                    return -1;
                }
                break block28;
            }
            if (neg1) break block28;
            if (runlen1 > runlen2) {
                return 1;
            }
            if (runlen1 < runlen2) {
                return -1;
            }
            while (runlen1-- != 0) {
                char c2;
                char c1;
                if ((c1 = firstString.charAt(start1++)) > (c2 = secondString.charAt(start2++))) {
                    return 1;
                }
                if (c1 >= c2) continue;
                return -1;
            }
        }
        return 0;
    }

    public static int assumeCompareAllBase(String firstString, String secondString) {
        block28: {
            int runlen2;
            int runlen1;
            int start2;
            int start1;
            boolean neg1;
            block27: {
                int str1length = firstString.length();
                int str2length = secondString.length();
                if (str1length == 0) {
                    if (str2length == 0) {
                        return 0;
                    }
                    return -1;
                }
                if (str2length == 0) {
                    return 1;
                }
                neg1 = false;
                boolean neg2 = false;
                start1 = 0;
                start2 = 0;
                if (firstString.charAt(0) == '-') {
                    neg1 = true;
                    start1 = 1;
                } else if (firstString.charAt(0) == '+') {
                    start1 = 1;
                }
                if (secondString.charAt(0) == '-') {
                    neg2 = true;
                    start2 = 1;
                } else if (secondString.charAt(0) == '+') {
                    start2 = 1;
                }
                while (start1 < str1length && firstString.charAt(start1) == '0') {
                    ++start1;
                }
                while (start2 < str2length && secondString.charAt(start2) == '0') {
                    ++start2;
                }
                runlen1 = str1length - start1;
                runlen2 = str2length - start2;
                if (runlen1 == 0) {
                    if (runlen2 == 0) {
                        return 0;
                    }
                    if (neg2) {
                        return 1;
                    }
                    return -1;
                }
                if (runlen2 == 0) {
                    if (neg1) {
                        return -1;
                    }
                    return 1;
                }
                if (neg1 != neg2) {
                    if (!neg1) {
                        return 1;
                    }
                    if (neg1) {
                        return -1;
                    }
                }
                if (!neg1) break block27;
                if (runlen1 > runlen2) {
                    return -1;
                }
                if (runlen1 < runlen2) {
                    return 1;
                }
                while (runlen1-- != 0) {
                    int c1 = firstString.charAt(start1++);
                    int c2 = secondString.charAt(start2++);
                    c1 = c1 > 96 ? (c1 -= 87) : (c1 > 64 ? (c1 -= 55) : (c1 ^= 0x30));
                    c2 = c2 > 96 ? (c2 -= 87) : (c2 > 64 ? (c2 -= 55) : (c2 ^= 0x30));
                    if (c1 < c2) {
                        return 1;
                    }
                    if (c1 <= c2) continue;
                    return -1;
                }
                break block28;
            }
            if (neg1) break block28;
            if (runlen1 > runlen2) {
                return 1;
            }
            if (runlen1 < runlen2) {
                return -1;
            }
            while (runlen1-- != 0) {
                int c1 = firstString.charAt(start1++);
                int c2 = secondString.charAt(start2++);
                c1 = c1 > 96 ? (c1 -= 87) : (c1 > 64 ? (c1 -= 55) : (c1 ^= 0x30));
                c2 = c2 > 96 ? (c2 -= 87) : (c2 > 64 ? (c2 -= 55) : (c2 ^= 0x30));
                if (c1 > c2) {
                    return 1;
                }
                if (c1 >= c2) continue;
                return -1;
            }
        }
        return 0;
    }

    public static int compare(String firstString, String secondString) {
        int str1length = firstString.length();
        int str2length = secondString.length();
        int out = 2;
        if (str1length == 0 || str2length == 0) {
            throw new EmptyStringException();
        }
        boolean neg1 = false;
        boolean neg2 = false;
        int start1 = 0;
        int start2 = 0;
        if (firstString.charAt(0) == '-') {
            if (str1length == 1) {
                throw new NumberFormatException(firstString);
            }
            neg1 = true;
            start1 = 1;
        } else if (firstString.charAt(0) == '+') {
            if (str1length == 1) {
                throw new NumberFormatException(firstString);
            }
            start1 = 1;
        }
        if (secondString.charAt(0) == '-') {
            if (str2length == 1) {
                throw new NumberFormatException(secondString);
            }
            neg2 = true;
            start2 = 1;
        } else if (secondString.charAt(0) == '+') {
            if (str2length == 1) {
                throw new NumberFormatException(secondString);
            }
            start2 = 1;
        }
        while (start1 < str1length && firstString.charAt(start1) == '0') {
            ++start1;
        }
        while (start2 < str2length && secondString.charAt(start2) == '0') {
            ++start2;
        }
        int runlen1 = str1length - start1;
        int runlen2 = str2length - start2;
        if (runlen1 == 0) {
            out = runlen2 == 0 ? 0 : (neg2 ? 1 : -1);
        } else if (runlen2 == 0) {
            out = neg1 ? -1 : 1;
        }
        if (out == 2 && neg1 != neg2) {
            if (!neg1) {
                out = 1;
            }
            if (neg1) {
                out = -1;
            }
        }
        if (out == 2) {
            char c2;
            char c1;
            if (neg1) {
                if (runlen1 > runlen2) {
                    out = -1;
                } else if (runlen1 < runlen2) {
                    out = 1;
                }
                if (out == 2) {
                    while (runlen1-- != 0) {
                        c1 = firstString.charAt(start1++);
                        c2 = secondString.charAt(start2++);
                        if ((c1 ^ 0x30) > 9) {
                            throw new NumberFormatException(firstString);
                        }
                        if ((c2 ^ 0x30) > 9) {
                            throw new NumberFormatException(secondString);
                        }
                        if (c1 < c2) {
                            out = 1;
                        } else {
                            if (c1 <= c2) continue;
                            out = -1;
                        }
                        break;
                    }
                }
            } else if (!neg1) {
                if (runlen1 > runlen2) {
                    out = 1;
                } else if (runlen1 < runlen2) {
                    out = -1;
                }
                if (out == 2) {
                    while (runlen1-- != 0) {
                        c1 = firstString.charAt(start1++);
                        c2 = secondString.charAt(start2++);
                        if ((c1 ^ 0x30) > 9) {
                            throw new NumberFormatException(firstString);
                        }
                        if ((c2 ^ 0x30) > 9) {
                            throw new NumberFormatException(secondString);
                        }
                        if (c1 > c2) {
                            out = 1;
                        } else {
                            if (c1 >= c2) continue;
                            out = -1;
                        }
                        break;
                    }
                }
            }
        }
        while (start1 < str1length) {
            if ((firstString.charAt(start1++) ^ 0x30) <= 9) continue;
            throw new NumberFormatException(firstString);
        }
        while (start2 < str2length) {
            if ((secondString.charAt(start2++) ^ 0x30) <= 9) continue;
            throw new NumberFormatException(secondString);
        }
        if (out == 2) {
            return 0;
        }
        return out;
    }

    public static int compareAsBase(String firstString, String secondString, int base) {
        int c2;
        int c1;
        if (base < 2 || base > 36) {
            throw new UnsupportedOperationException("Unsupported base. Input base: " + base + ".");
        }
        int str1length = firstString.length();
        int str2length = secondString.length();
        int out = 2;
        if (str1length == 0 || str2length == 0) {
            throw new EmptyStringException();
        }
        boolean neg1 = false;
        boolean neg2 = false;
        int start1 = 0;
        int start2 = 0;
        if (firstString.charAt(0) == '-') {
            if (str1length == 1) {
                throw new NumberFormatException(firstString);
            }
            neg1 = true;
            start1 = 1;
        } else if (firstString.charAt(0) == '+') {
            if (str1length == 1) {
                throw new NumberFormatException(firstString);
            }
            start1 = 1;
        }
        if (secondString.charAt(0) == '-') {
            if (str2length == 1) {
                throw new NumberFormatException(secondString);
            }
            neg2 = true;
            start2 = 1;
        } else if (secondString.charAt(0) == '+') {
            if (str2length == 1) {
                throw new NumberFormatException(secondString);
            }
            start2 = 1;
        }
        while (start1 < str1length && firstString.charAt(start1) == '0') {
            ++start1;
        }
        while (start2 < str2length && secondString.charAt(start2) == '0') {
            ++start2;
        }
        int runlen1 = str1length - start1;
        int runlen2 = str2length - start2;
        if (runlen1 == 0) {
            out = runlen2 == 0 ? 0 : (neg2 ? 1 : -1);
        } else if (runlen2 == 0) {
            out = neg1 ? -1 : 1;
        }
        if (out == 2 && neg1 != neg2) {
            if (!neg1) {
                out = 1;
            }
            if (neg1) {
                out = -1;
            }
        }
        if (out == 2) {
            if (neg1) {
                if (runlen1 > runlen2) {
                    out = -1;
                } else if (runlen1 < runlen2) {
                    out = 1;
                }
                if (out == 2) {
                    while (runlen1-- != 0) {
                        c1 = firstString.charAt(start1++);
                        c2 = secondString.charAt(start2++);
                        if (c1 > 96) {
                            c1 -= 87;
                        } else if (c1 > 64) {
                            c1 -= 55;
                        } else if ((c1 ^= 0x30) > 9) {
                            throw new NumberFormatException(firstString);
                        }
                        if (c1 >= base) {
                            throw new NumberFormatException(firstString);
                        }
                        if (c2 > 96) {
                            c2 -= 87;
                        } else if (c2 > 64) {
                            c2 -= 55;
                        } else if ((c2 ^= 0x30) > 9) {
                            throw new NumberFormatException(secondString);
                        }
                        if (c2 >= base) {
                            throw new NumberFormatException(secondString);
                        }
                        if (c1 < c2) {
                            out = 1;
                        } else {
                            if (c1 <= c2) continue;
                            out = -1;
                        }
                        break;
                    }
                }
            } else if (!neg1) {
                if (runlen1 > runlen2) {
                    out = 1;
                } else if (runlen1 < runlen2) {
                    out = -1;
                }
                if (out == 2) {
                    while (runlen1-- != 0) {
                        c1 = firstString.charAt(start1++);
                        c2 = secondString.charAt(start2++);
                        if (c1 > 96) {
                            c1 -= 87;
                        } else if (c1 > 64) {
                            c1 -= 55;
                        } else if ((c1 ^= 0x30) > 9) {
                            throw new NumberFormatException(firstString);
                        }
                        if (c1 >= base) {
                            throw new NumberFormatException(firstString);
                        }
                        if (c2 > 96) {
                            c2 -= 87;
                        } else if (c2 > 64) {
                            c2 -= 55;
                        } else if ((c2 ^= 0x30) > 9) {
                            throw new NumberFormatException(secondString);
                        }
                        if (c2 >= base) {
                            throw new NumberFormatException(secondString);
                        }
                        if (c1 > c2) {
                            out = 1;
                        } else {
                            if (c1 >= c2) continue;
                            out = -1;
                        }
                        break;
                    }
                }
            }
        }
        while (start1 < str1length) {
            if ((c1 = firstString.charAt(start1++)) > 96) {
                c1 -= 87;
            } else if (c1 > 64) {
                c1 -= 55;
            } else if ((c1 ^= 0x30) > 9) {
                throw new NumberFormatException(firstString);
            }
            if (c1 < base) continue;
            throw new NumberFormatException(firstString);
        }
        while (start2 < str2length) {
            if ((c2 = secondString.charAt(start2++)) > 96) {
                c2 -= 87;
            } else if (c2 > 64) {
                c2 -= 55;
            } else if ((c2 ^= 0x30) > 9) {
                throw new NumberFormatException(secondString);
            }
            if (c2 < base) continue;
            throw new NumberFormatException(secondString);
        }
        if (out == 2) {
            return 0;
        }
        return out;
    }
}

