/*
 * Decompiled with CFR 0.152.
 */
package host.minestudio.frost.api.shards;

import host.minestudio.frost.api.config.ConfigSchema;
import host.minestudio.frost.api.shards.ShardClassLoader;
import host.minestudio.frost.api.shards.ShardDependencyLoader;
import host.minestudio.frost.api.shards.ShardInfo;
import host.minestudio.frost.api.shards.command.ShardCommand;
import host.minestudio.frost.api.shards.enum.LogLevel;
import host.minestudio.frost.api.shards.helper.LogEmitter;
import host.minestudio.frost.api.shards.helper.ShardHelper;
import host.minestudio.frost.api.shards.helper.StorageService;
import java.io.File;
import java.net.URL;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020+H&J\b\u0010-\u001a\u00020+H&J\u0010\u00102\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0004J\b\u00105\u001a\u000206H\u0004J\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u00020+2\u0006\u0010:\u001a\u00020;J\u000e\u0010<\u001a\u00020+2\u0006\u0010\u0004\u001a\u00020=R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\u0004\u0018\u00010\u00178\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u00020\u001d8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001f\"\u0004\b#\u0010!R\u001a\u0010$\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001f\"\u0004\b%\u0010!R\u001e\u0010&\u001a\u00020\u001d8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010!R\u001a\u0010(\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u001f\"\u0004\b)\u0010!R\u0013\u0010.\u001a\u0004\u0018\u00010/8G\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u0006>"}, d2={"Lhost/minestudio/frost/api/shards/Shard;", "", "<init>", "()V", "loader", "Lhost/minestudio/frost/api/shards/ShardClassLoader;", "getLoader", "()Lhost/minestudio/frost/api/shards/ShardClassLoader;", "setLoader", "(Lhost/minestudio/frost/api/shards/ShardClassLoader;)V", "shardHelper", "Lhost/minestudio/frost/api/shards/helper/ShardHelper;", "getShardHelper", "()Lhost/minestudio/frost/api/shards/helper/ShardHelper;", "setShardHelper", "(Lhost/minestudio/frost/api/shards/helper/ShardHelper;)V", "dataFolder", "Ljava/io/File;", "getDataFolder", "()Ljava/io/File;", "setDataFolder", "(Ljava/io/File;)V", "info", "Lhost/minestudio/frost/api/shards/ShardInfo;", "getInfo", "()Lhost/minestudio/frost/api/shards/ShardInfo;", "setInfo", "(Lhost/minestudio/frost/api/shards/ShardInfo;)V", "hasContext", "", "getHasContext", "()Z", "setHasContext", "(Z)V", "isPreSetup", "setPreSetup", "isInPreSeup", "setInPreSeup", "isSetup", "setSetup", "isInSetup", "setInSetup", "presetup", "", "create", "delete", "jarLocation", "Ljava/net/URL;", "getJarLocation", "()Ljava/net/URL;", "publishConfigSchema", "schema", "Lhost/minestudio/frost/api/config/ConfigSchema;", "getStorageService", "Lhost/minestudio/frost/api/shards/helper/StorageService;", "getLogEmitter", "Lhost/minestudio/frost/api/shards/helper/LogEmitter;", "registerCommand", "command", "Lhost/minestudio/frost/api/shards/command/ShardCommand;", "setDependencyloader", "Lhost/minestudio/frost/api/shards/ShardDependencyLoader;", "api"})
public abstract class Shard {
    @ApiStatus.Internal
    public ShardClassLoader loader;
    @ApiStatus.Internal
    public ShardHelper shardHelper;
    public File dataFolder;
    @ApiStatus.Internal
    @Nullable
    private ShardInfo info;
    @ApiStatus.Internal
    private boolean hasContext;
    private boolean isPreSetup;
    private boolean isInPreSeup;
    @ApiStatus.Internal
    private boolean isSetup;
    private boolean isInSetup;

    @NotNull
    public final ShardClassLoader getLoader() {
        ShardClassLoader shardClassLoader = this.loader;
        if (shardClassLoader != null) {
            return shardClassLoader;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"loader");
        return null;
    }

    public final void setLoader(@NotNull ShardClassLoader shardClassLoader) {
        Intrinsics.checkNotNullParameter((Object)shardClassLoader, (String)"<set-?>");
        this.loader = shardClassLoader;
    }

    @NotNull
    public final ShardHelper getShardHelper() {
        ShardHelper shardHelper = this.shardHelper;
        if (shardHelper != null) {
            return shardHelper;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"shardHelper");
        return null;
    }

    public final void setShardHelper(@NotNull ShardHelper shardHelper) {
        Intrinsics.checkNotNullParameter((Object)shardHelper, (String)"<set-?>");
        this.shardHelper = shardHelper;
    }

    @NotNull
    public final File getDataFolder() {
        File file = this.dataFolder;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dataFolder");
        return null;
    }

    public final void setDataFolder(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.dataFolder = file;
    }

    @Nullable
    public final ShardInfo getInfo() {
        return this.info;
    }

    public final void setInfo(@Nullable ShardInfo shardInfo) {
        this.info = shardInfo;
    }

    public final boolean getHasContext() {
        return this.hasContext;
    }

    public final void setHasContext(boolean bl) {
        this.hasContext = bl;
    }

    public final boolean isPreSetup() {
        return this.isPreSetup;
    }

    public final void setPreSetup(boolean bl) {
        this.isPreSetup = bl;
    }

    public final boolean isInPreSeup() {
        return this.isInPreSeup;
    }

    public final void setInPreSeup(boolean bl) {
        this.isInPreSeup = bl;
    }

    public final boolean isSetup() {
        return this.isSetup;
    }

    public final void setSetup(boolean bl) {
        this.isSetup = bl;
    }

    public final boolean isInSetup() {
        return this.isInSetup;
    }

    public final void setInSetup(boolean bl) {
        this.isInSetup = bl;
    }

    public void presetup() {
    }

    public abstract void create();

    public abstract void delete();

    @ApiStatus.Internal
    @Nullable
    public final URL getJarLocation() {
        return this.getClass().getProtectionDomain().getCodeSource().getLocation();
    }

    protected final void publishConfigSchema(@NotNull ConfigSchema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        if (!this.isInSetup) {
            throw new IllegalStateException("You can only register Config Schemas during the SETUP phase of a shard.");
        }
        this.getShardHelper().registerConfigSchema(schema);
    }

    @NotNull
    protected final StorageService getStorageService() {
        if (!this.hasContext) {
            throw new IllegalStateException("This shard does not have contex assigned yet. Please ensure you're calling this after presetup or create, and not during a constructor.");
        }
        return this.getShardHelper().getStorageService();
    }

    @NotNull
    public final LogEmitter getLogEmitter() {
        if (!this.hasContext) {
            throw new IllegalStateException("This shard does not have context assigned yet. Please ensure you're calling this after presetup or create, and not during a constructor.");
        }
        Function2 logger = (arg_0, arg_1) -> Shard.getLogEmitter$lambda$0(this, arg_0, arg_1);
        return new LogEmitter((Function2<? super LogLevel, ? super String, Unit>)logger);
    }

    public final void registerCommand(@NotNull ShardCommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (!this.hasContext) {
            throw new IllegalStateException("This shard does not have context assigned yet. Please ensure you're calling this after presetup or create, and not during a constructor.");
        }
        this.getShardHelper().registerCommand(command);
    }

    public final void setDependencyloader(@NotNull ShardDependencyLoader loader) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        if (!this.hasContext) {
            throw new IllegalStateException("This shard does not have context assigned yet. Please ensure you're calling this after presetup or create, and not during a constructor.");
        }
        this.getShardHelper().setShardAppointedDependencyLoader(loader);
    }

    private static final Unit getLogEmitter$lambda$0(Shard this$0, LogLevel level, String message) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this$0.getShardHelper().emitLog(level, message);
        return Unit.INSTANCE;
    }
}

