/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.time.Clock;
import java.time.DateTimeException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.DateTimeFormatException;
import kotlinx.datetime.serializers.InstantIso8601Serializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Serializable(with=InstantIso8601Serializer.class)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001!B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\nH\u0016J\u001e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J!\u0010\u0015\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0000H\u0086\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001d\u0010\u0019J\u0006\u0010\u001e\u001a\u00020\u0006J\b\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\""}, d2={"Lkotlinx/datetime/Instant;", "", "value", "Ljava/time/Instant;", "(Ljava/time/Instant;)V", "epochSeconds", "", "getEpochSeconds", "()J", "nanosecondsOfSecond", "", "getNanosecondsOfSecond", "()I", "getValue$kotlinx_datetime", "()Ljava/time/Instant;", "compareTo", "other", "equals", "", "", "hashCode", "minus", "duration", "Lkotlin/time/Duration;", "minus-LRDsOJo", "(J)Lkotlinx/datetime/Instant;", "minus-5sfh64U", "(Lkotlinx/datetime/Instant;)J", "plus", "plus-LRDsOJo", "toEpochMilliseconds", "toString", "", "Companion", "kotlinx-datetime"})
public final class Instant
implements Comparable<Instant> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final java.time.Instant value;
    @NotNull
    private static final Instant DISTANT_PAST;
    @NotNull
    private static final Instant DISTANT_FUTURE;
    @NotNull
    private static final Instant MIN;
    @NotNull
    private static final Instant MAX;

    public Instant(@NotNull java.time.Instant value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.value = value;
    }

    @NotNull
    public final java.time.Instant getValue$kotlinx_datetime() {
        return this.value;
    }

    public final long getEpochSeconds() {
        return this.value.getEpochSecond();
    }

    public final int getNanosecondsOfSecond() {
        return this.value.getNano();
    }

    public final long toEpochMilliseconds() {
        long l;
        try {
            l = this.value.toEpochMilli();
        }
        catch (ArithmeticException e) {
            l = this.value.isAfter(java.time.Instant.EPOCH) ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Instant plus-LRDsOJo(long duration) {
        Comparable<Instant> comparable;
        boolean bl = false;
        int n = Duration.getNanosecondsComponent-impl(duration);
        long seconds = Duration.getInWholeSeconds-impl(duration);
        boolean bl2 = false;
        try {
            void nanoseconds;
            comparable = this.getValue$kotlinx_datetime().plusSeconds(seconds).plusNanos((long)nanoseconds);
            Intrinsics.checkNotNullExpressionValue(comparable, "value.plusSeconds(second\u2026nos(nanoseconds.toLong())");
            comparable = new Instant((java.time.Instant)comparable);
        }
        catch (Exception e) {
            if (!(e instanceof ArithmeticException) && !(e instanceof DateTimeException)) {
                throw e;
            }
            comparable = Duration.isPositive-impl(duration) ? MAX : MIN;
        }
        return comparable;
    }

    @NotNull
    public final Instant minus-LRDsOJo(long duration) {
        return this.plus-LRDsOJo(Duration.unaryMinus-UwyO8pc(duration));
    }

    public final long minus-5sfh64U(@NotNull Instant other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Duration.plus-LRDsOJo(DurationKt.toDuration(this.value.getEpochSecond() - other.value.getEpochSecond(), DurationUnit.SECONDS), DurationKt.toDuration(this.value.getNano() - other.value.getNano(), DurationUnit.NANOSECONDS));
    }

    @Override
    public int compareTo(@NotNull Instant other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.value.compareTo(other.value);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof Instant && Intrinsics.areEqual(this.value, ((Instant)other).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @NotNull
    public String toString() {
        String string = this.value.toString();
        Intrinsics.checkNotNullExpressionValue(string, "value.toString()");
        return string;
    }

    static {
        java.time.Instant instant = java.time.Instant.ofEpochSecond(-3217862419201L, 999999999L);
        Intrinsics.checkNotNullExpressionValue(instant, "ofEpochSecond(DISTANT_PAST_SECONDS, 999_999_999)");
        DISTANT_PAST = new Instant(instant);
        instant = java.time.Instant.ofEpochSecond(3093527980800L, 0L);
        Intrinsics.checkNotNullExpressionValue(instant, "ofEpochSecond(DISTANT_FUTURE_SECONDS, 0)");
        DISTANT_FUTURE = new Instant(instant);
        instant = java.time.Instant.MIN;
        Intrinsics.checkNotNullExpressionValue(instant, "MIN");
        MIN = new Instant(instant);
        instant = java.time.Instant.MAX;
        Intrinsics.checkNotNullExpressionValue(instant, "MAX");
        MAX = new Instant(instant);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u0012J\b\u0010\u0017\u001a\u00020\u0004H\u0007J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000eJ\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u001aH\u00c6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lkotlinx/datetime/Instant$Companion;", "", "()V", "DISTANT_FUTURE", "Lkotlinx/datetime/Instant;", "getDISTANT_FUTURE", "()Lkotlinx/datetime/Instant;", "DISTANT_PAST", "getDISTANT_PAST", "MAX", "getMAX$kotlinx_datetime", "MIN", "getMIN$kotlinx_datetime", "fixOffsetRepresentation", "", "isoString", "fromEpochMilliseconds", "epochMilliseconds", "", "fromEpochSeconds", "epochSeconds", "nanosecondAdjustment", "", "now", "parse", "serializer", "Lkotlinx/serialization/KSerializer;", "kotlinx-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Use Clock.System.now() instead", replaceWith=@ReplaceWith(expression="Clock.System.now()", imports={"kotlinx.datetime.Clock"}), level=DeprecationLevel.ERROR)
        @NotNull
        public final Instant now() {
            java.time.Instant instant = Clock.systemUTC().instant();
            Intrinsics.checkNotNullExpressionValue(instant, "systemUTC().instant()");
            return new Instant(instant);
        }

        @NotNull
        public final Instant fromEpochMilliseconds(long epochMilliseconds) {
            java.time.Instant instant = java.time.Instant.ofEpochMilli(epochMilliseconds);
            Intrinsics.checkNotNullExpressionValue(instant, "ofEpochMilli(epochMilliseconds)");
            return new Instant(instant);
        }

        @NotNull
        public final Instant parse(@NotNull String isoString) {
            Comparable<java.time.Instant> comparable;
            Intrinsics.checkNotNullParameter(isoString, "isoString");
            try {
                comparable = OffsetDateTime.parse(this.fixOffsetRepresentation(isoString)).toInstant();
                Intrinsics.checkNotNullExpressionValue(comparable, "parse(fixOffsetRepresent\u2026n(isoString)).toInstant()");
                comparable = new Instant((java.time.Instant)comparable);
            }
            catch (DateTimeParseException e) {
                throw new DateTimeFormatException(e);
            }
            return comparable;
        }

        private final String fixOffsetRepresentation(String isoString) {
            int offset;
            int time;
            block4: {
                int n;
                time = StringsKt.indexOf$default((CharSequence)isoString, 'T', 0, true, 2, null);
                if (time == -1) {
                    return isoString;
                }
                CharSequence $this$indexOfLast$iv = isoString;
                boolean $i$f$indexOfLast = false;
                int n2 = $this$indexOfLast$iv.length() + -1;
                if (0 <= n2) {
                    do {
                        int index$iv = n2--;
                        char c = $this$indexOfLast$iv.charAt(index$iv);
                        boolean bl = false;
                        if (!(c == '+' || c == '-')) continue;
                        n = index$iv;
                        break block4;
                    } while (0 <= n2);
                }
                n = offset = -1;
            }
            if (offset < time) {
                return isoString;
            }
            int separator = StringsKt.indexOf$default((CharSequence)isoString, ':', offset, false, 4, null);
            return separator != -1 ? isoString : Intrinsics.stringPlus(isoString, ":00");
        }

        @NotNull
        public final Instant fromEpochSeconds(long epochSeconds, long nanosecondAdjustment) {
            Comparable<java.time.Instant> comparable;
            try {
                comparable = java.time.Instant.ofEpochSecond(epochSeconds, nanosecondAdjustment);
                Intrinsics.checkNotNullExpressionValue(comparable, "ofEpochSecond(epochSeconds, nanosecondAdjustment)");
                comparable = new Instant((java.time.Instant)comparable);
            }
            catch (Exception e) {
                if (!(e instanceof ArithmeticException) && !(e instanceof DateTimeException)) {
                    throw e;
                }
                comparable = epochSeconds > 0L ? this.getMAX$kotlinx_datetime() : this.getMIN$kotlinx_datetime();
            }
            return comparable;
        }

        public static /* synthetic */ Instant fromEpochSeconds$default(Companion companion, long l, long l2, int n, Object object) {
            if ((n & 2) != 0) {
                l2 = 0L;
            }
            return companion.fromEpochSeconds(l, l2);
        }

        @NotNull
        public final Instant fromEpochSeconds(long epochSeconds, int nanosecondAdjustment) {
            return this.fromEpochSeconds(epochSeconds, (long)nanosecondAdjustment);
        }

        @NotNull
        public final Instant getDISTANT_PAST() {
            return DISTANT_PAST;
        }

        @NotNull
        public final Instant getDISTANT_FUTURE() {
            return DISTANT_FUTURE;
        }

        @NotNull
        public final Instant getMIN$kotlinx_datetime() {
            return MIN;
        }

        @NotNull
        public final Instant getMAX$kotlinx_datetime() {
            return MAX;
        }

        @NotNull
        public final KSerializer<Instant> serializer() {
            return InstantIso8601Serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

