/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.depgraph_view;

import com.google.common.collect.ImmutableMap;
import hudson.Launcher;
import hudson.model.AbstractModelObject;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.DependencyGraph;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.depgraph_view.AbstractDependencyGraphAction;
import hudson.plugins.depgraph_view.CalculateDeps;
import hudson.plugins.depgraph_view.DependencyGraphProperty;
import hudson.plugins.depgraph_view.Messages;
import hudson.util.LogTaskListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDependencyGraphAction
implements Action {
    private final Logger LOGGER = Logger.getLogger(Logger.class.getName());
    protected static final ImmutableMap<String, SupportedImageType> extension2Type = ImmutableMap.of((Object)"png", (Object)SupportedImageType.of((String)"image/png", (String)"png"), (Object)"svg", (Object)SupportedImageType.of((String)"image/svg", (String)"svg"), (Object)"map", (Object)SupportedImageType.of((String)"image/cmapx", (String)"cmapx"), (Object)"gv", (Object)SupportedImageType.of((String)"text/plain", (String)"gv"));
    private static final Comparator<DependencyGraph.Dependency> DEP_COMPARATOR = new /* Unavailable Anonymous Inner Class!! */;
    private static final Comparator<AbstractProject<?, ?>> PROJECT_COMPARATOR = new /* Unavailable Anonymous Inner Class!! */;

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String path = req.getRestOfPath();
        if (path.startsWith("/graph.")) {
            String extension = path.substring("/graph.".length());
            if (extension2Type.containsKey((Object)extension.toLowerCase())) {
                SupportedImageType imageType = (SupportedImageType)extension2Type.get((Object)extension.toLowerCase());
                CalculateDeps calculateDeps = new CalculateDeps(this.getProjectsForDepgraph());
                String graphDot = this.generateDotText(calculateDeps.getProjects(), calculateDeps.getDependencies());
                rsp.setContentType(imageType.contentType);
                if ("gv".equalsIgnoreCase(extension)) {
                    rsp.getWriter().append(graphDot).close();
                } else {
                    this.runDot((OutputStream)rsp.getOutputStream(), (InputStream)new ByteArrayInputStream(graphDot.getBytes()), imageType.dotType);
                }
            }
        } else {
            rsp.sendError(501);
            return;
        }
    }

    public String generateDotText(Set<AbstractProject<?, ?>> projects, Set<DependencyGraph.Dependency> deps) {
        ArrayList<DependencyGraph.Dependency> sortedDeps = new ArrayList<DependencyGraph.Dependency>(deps);
        Collections.sort(sortedDeps, DEP_COMPARATOR);
        ArrayList<AbstractProject> depProjects = new ArrayList<AbstractProject>();
        for (DependencyGraph.Dependency dependency : sortedDeps) {
            depProjects.add(dependency.getUpstreamProject());
            depProjects.add(dependency.getDownstreamProject());
        }
        ArrayList<AbstractProject<AbstractProject, AbstractProject>> sortedProjects = new ArrayList<AbstractProject<AbstractProject, AbstractProject>>(projects);
        sortedProjects.removeAll(depProjects);
        Collections.sort(sortedProjects, PROJECT_COMPARATOR);
        Collections.sort(depProjects, PROJECT_COMPARATOR);
        sortedProjects.addAll(depProjects);
        StringBuilder builder = new StringBuilder("digraph {\n");
        builder.append("node [shape=box, style=rounded];\n");
        builder.append("subgraph clusterdepgraph {\n");
        for (AbstractProject abstractProject : sortedProjects) {
            builder.append(this.projectToNodeString(abstractProject)).append(";\n");
        }
        for (DependencyGraph.Dependency dependency : sortedDeps) {
            builder.append(this.dependencyToEdgeString(dependency));
            builder.append(";\n");
        }
        builder.append("color=white;\n}\n");
        return builder.append("}").toString();
    }

    private String projectToNodeString(AbstractProject<?, ?> proj) {
        return this.escapeString(proj.getName()) + " [href=" + this.escapeString(Hudson.getInstance().getRootUrlFromRequest() + proj.getUrl()) + "]";
    }

    private String dependencyToEdgeString(DependencyGraph.Dependency dep) {
        return this.escapeString(dep.getUpstreamProject().getName()) + " -> " + this.escapeString(dep.getDownstreamProject().getName());
    }

    private String escapeString(String toEscape) {
        return "\"" + toEscape + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runDot(OutputStream output, InputStream input, String type) throws IOException {
        DependencyGraphProperty.DescriptorImpl descriptor = (DependencyGraphProperty.DescriptorImpl)Hudson.getInstance().getDescriptorByType(DependencyGraphProperty.DescriptorImpl.class);
        String dotPath = descriptor.getDotExeOrDefault();
        Launcher launcher = Hudson.getInstance().createLauncher((TaskListener)new LogTaskListener(this.LOGGER, Level.CONFIG));
        try {
            launcher.launch().cmds(new String[]{dotPath, "-T" + type}).stdin(input).stdout(output).start().join();
        }
        catch (InterruptedException e) {
            this.LOGGER.severe("Interrupted while waiting for dot-file to be created:" + e);
            e.printStackTrace();
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    protected abstract Collection<? extends AbstractProject<?, ?>> getProjectsForDepgraph();

    public abstract String getTitle();

    public abstract AbstractModelObject getParentObject();

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getDisplayName() {
        return Messages.AbstractDependencyGraphAction_DependencyGraph();
    }

    public String getUrlName() {
        return "depgraph-view";
    }

    static /* synthetic */ Comparator access$000() {
        return PROJECT_COMPARATOR;
    }
}

