/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.depgraph_view;

import hudson.model.AbstractProject;
import hudson.model.DependencyGraph;
import hudson.model.Hudson;
import hudson.model.Item;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalculateDeps {
    private static final Logger LOGGER = Logger.getLogger(CalculateDeps.class.getName());
    private final Set<DependencyGraph.Dependency> visitedDeps = new HashSet();
    private final Set<AbstractProject<?, ?>> visitedProj = new HashSet();
    private boolean calculated = false;
    private DependencyGraph dependencyGraph = Hudson.getInstance().getDependencyGraph();

    public CalculateDeps(Collection<? extends AbstractProject<?, ?>> projects) {
        this.visitedProj.addAll(projects);
    }

    public void calculateNodesAndDependencies() {
        if (!this.calculated) {
            this.calculateNodesAndDependencies(this.visitedProj);
            this.calculated = true;
        }
    }

    private void calculateNodesAndDependencies(Set<AbstractProject<?, ?>> fromProjects) {
        HashSet newProj = new HashSet();
        for (AbstractProject<?, ?> project : fromProjects) {
            if (!project.hasPermission(Item.READ)) continue;
            newProj.addAll(this.addNewDependencies((Collection)this.dependencyGraph.getUpstreamDependencies(project), true));
            newProj.addAll(this.addNewDependencies((Collection)this.dependencyGraph.getDownstreamDependencies(project), false));
        }
        this.visitedProj.addAll(newProj);
        if (!newProj.isEmpty()) {
            this.calculateNodesAndDependencies(newProj);
        }
    }

    private Set<AbstractProject<?, ?>> addNewDependencies(Collection<DependencyGraph.Dependency> dependencies, boolean isUpstream) {
        HashSet newProj = new HashSet();
        for (DependencyGraph.Dependency dep : dependencies) {
            AbstractProject projectToAdd = isUpstream ? dep.getUpstreamProject() : dep.getDownstreamProject();
            if (!projectToAdd.hasPermission(Item.READ) || this.visitedDeps.contains(dep)) continue;
            this.visitedDeps.add(dep);
            if (this.visitedProj.contains(projectToAdd)) continue;
            newProj.add(projectToAdd);
        }
        return newProj;
    }

    public Set<AbstractProject<?, ?>> getProjects() {
        if (!this.calculated) {
            this.calculateNodesAndDependencies();
        }
        return Collections.unmodifiableSet(this.visitedProj);
    }

    public Set<DependencyGraph.Dependency> getDependencies() {
        if (!this.calculated) {
            this.calculateNodesAndDependencies();
        }
        return Collections.unmodifiableSet(this.visitedDeps);
    }
}

